/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.runtime.AbstractBetaConditionNode;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.BetaConditionNode;
import org.evrete.runtime.BetaEntryNode;
import org.evrete.runtime.BetaMemoryNode;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.EntryNodeDescriptor;
import org.evrete.runtime.Mask;
import org.evrete.runtime.MemoryAddress;
import org.evrete.runtime.NodeDescriptor;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeRuleImpl;

public class BetaEndNode
extends BetaConditionNode
implements RhsFactGroup {
    private final RuntimeFactType[] entryNodes;
    private final Mask<MemoryAddress> memoryMask;

    BetaEndNode(RuntimeRuleImpl rule, ConditionNodeDescriptor nodeDescriptor, boolean singleGroup) {
        super(rule, nodeDescriptor, BetaEndNode.create(nodeDescriptor.getSources(), rule));
        this.entryNodes = rule.asRuntimeTypes(nodeDescriptor.getTypes());
        this.memoryMask = nodeDescriptor.getMemoryMask();
        this.setMergeToMain(!singleGroup);
    }

    private static BetaMemoryNode create(RuntimeRuleImpl rule, NodeDescriptor desc) {
        if (desc.isConditionNode()) {
            return new BetaConditionNode(rule, (ConditionNodeDescriptor)desc, BetaEndNode.create(desc.getSources(), rule));
        }
        EntryNodeDescriptor descriptor = (EntryNodeDescriptor)desc;
        return new BetaEntryNode((AbstractRuleSession<?>)rule.getRuntime(), descriptor);
    }

    private static BetaMemoryNode[] create(NodeDescriptor[] sources, RuntimeRuleImpl rule) {
        BetaMemoryNode[] result = new BetaMemoryNode[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            result[i] = BetaEndNode.create(rule, sources[i]);
        }
        return result;
    }

    @Override
    public ReIterator<MemoryKey> keyIterator(KeyMode mode) {
        return this.iterator(mode);
    }

    @Override
    public RuntimeFactType[] types() {
        return this.entryNodes;
    }

    @Override
    public void commitDelta() {
        this.forEachConditionNode(AbstractBetaConditionNode::commitDeltaMemory);
    }

    @Override
    public Mask<MemoryAddress> getMemoryMask() {
        return this.memoryMask;
    }
}

