/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FieldValue;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.FactRecord;

public class RuntimeFact {
    static final RuntimeFact DUMMY_FACT = new RuntimeFact(){

        @Override
        boolean sameValues(RuntimeFact other) {
            return false;
        }
    };
    private static final BitSet EMPTY = new BitSet();
    public final FactHandleVersioned factHandle;
    public final FactRecord factRecord;
    final BitSet alphaTests;
    private final FieldValue[] fieldValues;

    private RuntimeFact() {
        this.factHandle = null;
        this.alphaTests = EMPTY;
        this.fieldValues = new FieldValue[0];
        this.factRecord = null;
    }

    RuntimeFact(FactRecord factRecord, FactHandleVersioned factHandle, FieldValue[] fieldValues, BitSet alphaTests) {
        this.fieldValues = fieldValues;
        this.factHandle = factHandle;
        this.alphaTests = alphaTests;
        this.factRecord = factRecord;
    }

    FieldValue getValue(ActiveField field) {
        return this.fieldValues[field.getValueIndex()];
    }

    boolean sameValues(RuntimeFact other) {
        if (other == null) {
            return false;
        }
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (Objects.equals(this.fieldValues[i], other.fieldValues[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{handle=" + this.factHandle + ", values=" + Arrays.toString(this.fieldValues) + '}';
    }
}

