/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FactStorage;
import org.evrete.api.FieldValue;
import org.evrete.api.IntToValue;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.api.ValueResolver;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.EvaluatorStorageImpl;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.InsertedFact;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.Mask;
import org.evrete.runtime.MemoryAddress;
import org.evrete.runtime.RuntimeFact;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemoryBase;
import org.evrete.runtime.TypeMemoryMetaData;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.runtime.evaluation.EvaluatorWrapper;

public final class TypeMemory
extends TypeMemoryBase {
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private Cache cache;

    TypeMemory(SessionMemory sessionMemory, int type) {
        super(sessionMemory, type);
        this.updateCachedData();
    }

    void updateCachedData() {
        this.cache = new Cache(this.type, this.getRuntime());
    }

    FactRecord getFactRecord(FactHandle handle) {
        return this.getStoredRecord(handle);
    }

    void forEachFact(BiConsumer<FactHandle, Object> consumer) {
        this.factStorage.iterator().forEachRemaining(record -> {
            FactHandle handle = record.getHandle();
            Object fact = ((FactRecord)record.getInstance()).instance;
            consumer.accept(handle, fact);
        });
    }

    Optional<InsertedFact> registerInsertedFact(Object fact) {
        FactRecord record = new FactRecord(fact);
        FactHandle handle = this.factStorage.insert(record);
        if (handle == null) {
            LOGGER.warning("Fact " + fact + " has been already inserted");
            return Optional.empty();
        }
        return Optional.of(new InsertedFact(handle, record));
    }

    public RuntimeFact createFactRuntime(FactHandle handle, FactRecord factRecord) {
        FactHandleVersioned factHandle = new FactHandleVersioned(handle, factRecord.getVersion());
        return this.cache.createFactRuntime(factHandle, factRecord, this.valueResolver);
    }

    void onNewAlphaBucket(MemoryAddress address) {
        KeyMemoryBucket bucket = this.touchMemory(address);
        Iterator allFacts = this.factStorage.iterator();
        LinkedList<RuntimeFact> runtimeFacts = new LinkedList<RuntimeFact>();
        while (allFacts.hasNext()) {
            FactStorage.Entry rec = (FactStorage.Entry)allFacts.next();
            runtimeFacts.add(this.createFactRuntime(rec.getHandle(), (FactRecord)rec.getInstance()));
        }
        bucket.insert(runtimeFacts);
        bucket.commitBuffer();
    }

    static class Cache {
        final TypeField[] fields;
        final AlphaPredicate[] alphaEvaluators;
        final Object[] currentValues;
        final boolean hasAlphaConditions;

        Cache(Type<?> type, AbstractRuleSession<?> runtime) {
            int i;
            Type t = runtime.getType(type.getId());
            TypeMemoryMetaData meta = runtime.getTypeMeta(t.getId());
            this.fields = new TypeField[meta.activeFields.length];
            for (i = 0; i < meta.activeFields.length; ++i) {
                TypeField tf;
                String fieldName = meta.activeFields[i].getName();
                this.fields[i] = tf = type.getField(fieldName);
            }
            this.currentValues = new Object[this.fields.length];
            this.hasAlphaConditions = meta.alphaEvaluators.length > 0;
            this.alphaEvaluators = new AlphaPredicate[meta.alphaEvaluators.length];
            if (this.hasAlphaConditions) {
                for (i = 0; i < this.alphaEvaluators.length; ++i) {
                    this.alphaEvaluators[i] = new AlphaPredicate(meta.alphaEvaluators[i], runtime.getEvaluators(), this.currentValues);
                }
            }
        }

        private RuntimeFact createFactRuntime(FactHandleVersioned factHandle, FactRecord factRecord, ValueResolver valueResolver) {
            BitSet alphaTests;
            FieldValue[] fieldValues = new FieldValue[this.fields.length];
            if (this.hasAlphaConditions) {
                for (int i = 0; i < fieldValues.length; ++i) {
                    TypeField f = this.fields[i];
                    Object fieldValue = f.readValue(factRecord.instance);
                    this.currentValues[i] = fieldValue;
                    fieldValues[i] = valueResolver.getValueHandle(f.getValueType(), fieldValue);
                }
                alphaTests = new BitSet();
                for (AlphaPredicate alphaEvaluator : this.alphaEvaluators) {
                    if (!alphaEvaluator.test()) continue;
                    alphaTests.set(alphaEvaluator.getIndex());
                }
            } else {
                for (int i = 0; i < fieldValues.length; ++i) {
                    TypeField f = this.fields[i];
                    fieldValues[i] = valueResolver.getValueHandle(f.getValueType(), f.readValue(factRecord.instance));
                }
                alphaTests = Mask.EMPTY;
            }
            return new RuntimeFact(factRecord, factHandle, fieldValues, alphaTests);
        }
    }

    static class AlphaPredicate {
        private final EvaluatorWrapper delegate;
        private final int index;
        private final IntToValue func;

        AlphaPredicate(AlphaEvaluator alphaEvaluator, EvaluatorStorageImpl evaluators, Object[] values) {
            this.delegate = evaluators.get(alphaEvaluator.getDelegate(), false);
            ActiveField[] activeDescriptor = alphaEvaluator.getDescriptor();
            this.index = alphaEvaluator.getIndex();
            int[] valueIndices = new int[activeDescriptor.length];
            for (int i2 = 0; i2 < valueIndices.length; ++i2) {
                valueIndices[i2] = activeDescriptor[i2].getValueIndex();
            }
            this.func = i -> values[valueIndices[i]];
        }

        int getIndex() {
            return this.index;
        }

        boolean test() {
            return this.delegate.test(this.func);
        }
    }
}

