/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Objects;
import java.util.function.Consumer;
import org.evrete.api.FactHandle;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FactStorage;
import org.evrete.api.Type;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.MemoryAddress;
import org.evrete.runtime.MemoryComponent;
import org.evrete.runtime.SessionMemory;

class TypeMemoryBase
extends MemoryComponent {
    final FactStorage<FactRecord> factStorage;
    final Type<?> type;
    private final ArrayOf<KeyMemoryBucket> memoryBuckets = new ArrayOf<KeyMemoryBucket>(KeyMemoryBucket.class);

    TypeMemoryBase(SessionMemory sessionMemory, int type) {
        super(sessionMemory);
        String identityMethod;
        Type t = this.getType(type);
        this.type = t;
        switch (identityMethod = this.configuration.getProperty("evrete.core.fact-identity-strategy")) {
            case "equals": {
                this.factStorage = this.memoryFactory.newFactStorage(t, FactRecord.class, (o1, o2) -> Objects.equals(o1.instance, o2.instance));
                break;
            }
            case "identity": {
                this.factStorage = this.memoryFactory.newFactStorage(t, FactRecord.class, (o1, o2) -> o1.instance == o2.instance);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid identity method '" + identityMethod + "' in the configuration. Expected values are '" + "equals" + "' or '" + "identity" + "'");
            }
        }
    }

    FactRecord getStoredRecord(FactHandle handle) {
        return this.factStorage.getFact(handle);
    }

    public boolean factExists(FactHandleVersioned handle) {
        FactRecord fact = this.factStorage.getFact(handle.getHandle());
        return fact != null && fact.getVersion() == handle.getVersion();
    }

    public FactStorage<FactRecord> getFactStorage() {
        return this.factStorage;
    }

    public void forEach(Consumer<? super KeyMemoryBucket> consumer) {
        this.memoryBuckets.forEach(consumer);
    }

    public final Type<?> getType() {
        return this.type;
    }

    @Override
    protected void clearLocalData() {
        this.factStorage.clear();
    }

    void destroy() {
        this.memoryBuckets.clear();
    }

    public ArrayOf<KeyMemoryBucket> getMemoryBuckets() {
        return this.memoryBuckets;
    }

    KeyMemoryBucket touchMemory(MemoryAddress address) {
        return this.getCreate(address);
    }

    private KeyMemoryBucket getCreate(MemoryAddress address) {
        return this.memoryBuckets.computeIfAbsent(address.getBucketIndex(), k -> KeyMemoryBucket.factory(this, address));
    }

    KeyMemoryBucket getMemoryBucket(MemoryAddress bucket) {
        int bucketIndex = bucket.getBucketIndex();
        if (bucketIndex >= this.memoryBuckets.length()) {
            throw new IllegalArgumentException("No alpha bucket created for " + bucket);
        }
        KeyMemoryBucket storage = this.memoryBuckets.get(bucketIndex);
        if (storage == null) {
            throw new IllegalArgumentException("No alpha bucket created for " + bucket);
        }
        return storage;
    }

    public String toString() {
        return "TypeMemory{" + this.type.getName() + '}';
    }
}

