/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

public class ClassMeta {
    private final String simpleName;
    private final String packageName;

    protected ClassMeta(String packageName, String simpleName) {
        this.simpleName = simpleName;
        this.packageName = packageName;
    }

    protected ClassMeta(String binaryName) {
        this(ClassMeta.packageName(binaryName), ClassMeta.simpleName(binaryName));
    }

    public String getBinaryName() {
        return this.packageName + "." + this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    static String packageName(String binaryName) {
        int dotPos = binaryName.lastIndexOf(46);
        if (dotPos < 0) {
            throw new IllegalArgumentException("Empty/default packages are not supported");
        }
        return binaryName.substring(0, dotPos);
    }

    static String simpleName(String binaryName) {
        int dotPos = binaryName.lastIndexOf(46);
        if (dotPos < 0) {
            throw new IllegalArgumentException("Empty/default packages are not supported");
        }
        return binaryName.substring(dotPos + 1);
    }
}

