/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import javax.tools.JavaFileObject;
import org.evrete.api.JavaSourceCompiler;
import org.evrete.runtime.compiler.AbstractJavaObject;
import org.evrete.runtime.compiler.ClassMeta;

class JavaSourceObject
extends AbstractJavaObject {
    private static final AtomicLong SOURCE_COUNTER = new AtomicLong();
    private final String simpleName;
    private final JavaSourceCompiler.ClassSource source;
    private final URI uri;

    JavaSourceObject(JavaSourceCompiler.ClassSource source) {
        ClassMeta meta = new ClassMeta(source.binaryName());
        this.simpleName = meta.getSimpleName();
        this.source = source;
        this.uri = URI.create("string:///source-" + SOURCE_COUNTER.incrementAndGet() + "." + JavaFileObject.Kind.SOURCE.extension);
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return kind == JavaFileObject.Kind.SOURCE && this.simpleName.equals(simpleName);
    }

    JavaSourceCompiler.ClassSource getSource() {
        return this.source;
    }

    static JavaSourceCompiler.ClassSource parse(final String source) {
        String src = JavaSourceObject.removeBlockComments(Objects.requireNonNull(source));
        String[] lines = src.replaceAll("\n\r", "\n").replaceAll("\r\n", "\n").replaceAll("\r", "\n").split("\n");
        StringBuilder sb = new StringBuilder(source.length());
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.startsWith("//")) continue;
            sb.append(trimmed).append('\n');
        }
        src = sb.toString().trim();
        int p = source.indexOf(123);
        if (p < 0) {
            throw new IllegalArgumentException("Not a Java source");
        }
        if ((p = (src = src.substring(0, p - 1).trim()).indexOf("package")) < 0) {
            throw new IllegalArgumentException("Unnamed (default) packages are not supported");
        }
        int semi = source.indexOf(59);
        if (semi < 0) {
            throw new IllegalArgumentException("Not a Java source");
        }
        String packageName = source.substring(p + "package".length() + 1, semi).trim();
        String[] parts = src.replaceAll("\\n", "").split(";");
        String classDef = parts[parts.length - 1];
        String[] words = classDef.split("\\s+");
        for (int i = 0; i < words.length - 1; ++i) {
            String w = words[i];
            if (!JavaSourceObject.isClassDef(w)) continue;
            final ClassMeta meta = new ClassMeta(packageName, words[i + 1].trim());
            return new JavaSourceCompiler.ClassSource(){

                @Override
                public String binaryName() {
                    return meta.getBinaryName();
                }

                @Override
                public String getSource() {
                    return source;
                }
            };
        }
        throw new IllegalArgumentException("Couldn't find any of the class|interface|enum|record keywords");
    }

    private static boolean isClassDef(String s) {
        return "class".equals(s) || "enum".equals(s) || "record".equals(s) || "interface".equals(s);
    }

    static String removeBlockComments(String arg) {
        int open = arg.indexOf("/*");
        if (open < 0) {
            return arg;
        }
        int close = arg.indexOf("*/", open + 2);
        if (close < 0) {
            throw new IllegalArgumentException("Malformed block comment in '" + arg + "'");
        }
        String blockRemoved = arg.substring(0, open) + arg.substring(close + 2);
        return JavaSourceObject.removeBlockComments(blockRemoved);
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.source.getSource().getBytes());
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.source.getSource();
    }

    @Override
    String getBinaryName() {
        return this.source.binaryName();
    }

    public String toString() {
        String sep = System.lineSeparator();
        StringBuilder sb = new StringBuilder(this.source.getSource().length() * 2);
        sb.append(sep).append('\'').append(this.getBinaryName()).append("':").append(sep);
        Scanner scanner = new Scanner(this.source.getSource());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            sb.append("\t").append(line).append(sep);
        }
        return sb.toString();
    }
}

