/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import org.evrete.api.FieldValue;
import org.evrete.spi.minimal.AbstractKeyedFactStorage;
import org.evrete.spi.minimal.FactsMapMulti;
import org.evrete.spi.minimal.MemoryKeyHashed;
import org.evrete.spi.minimal.MemoryKeyMulti;

class KeyedFactStorageMulti
extends AbstractKeyedFactStorage<MemoryKeyMulti, FactsMapMulti> {
    private final MultiState multiState;

    KeyedFactStorageMulti(int fieldCount) {
        super(FactsMapMulti.class, mode -> new FactsMapMulti(fieldCount));
        this.multiState = new MultiState(fieldCount);
    }

    @Override
    MemoryKeyHashed writeKey(FieldValue h) {
        return this.multiState.update(h);
    }

    static class MultiState
    extends MemoryKeyHashed {
        private final FieldValue[] data;
        private int currentPosition = 0;

        MultiState(int size) {
            this.data = new FieldValue[size];
            this.values = i -> this.data[i];
        }

        MultiState update(FieldValue h) {
            if (this.currentPosition == this.data.length) {
                this.currentPosition = 0;
                this.hash = 0;
            }
            this.data[this.currentPosition++] = h;
            this.hash += 37 * h.hashCode();
            return this;
        }
    }
}

