/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.evrete.api.Action;
import org.evrete.api.FactHandle;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.collections.LinearHashSet;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FactRecordDelta;

public class FactActionBuffer {
    private final Map<Integer, ActionQueue> typedQueues = new ConcurrentHashMap<Integer, ActionQueue>();
    private long totalActions = 0L;

    boolean hasData() {
        return this.totalActions > 0L;
    }

    private void add(Action action, FactHandle factHandle, FactRecordDelta delta) {
        if (this.get(factHandle).add(action, factHandle, Objects.requireNonNull(delta))) {
            ++this.totalActions;
        }
    }

    AtomicMemoryAction find(FactHandle factHandle) {
        return this.get(factHandle).get(factHandle);
    }

    void clear() {
        this.typedQueues.values().forEach(ActionQueue::clear);
        this.totalActions = 0L;
    }

    private ActionQueue get(Type<?> t) {
        return this.get(t.getId());
    }

    private ActionQueue get(FactHandle h) {
        return this.get(h.getTypeId());
    }

    private ActionQueue get(int typeId) {
        return this.typedQueues.computeIfAbsent(typeId, i -> new ActionQueue());
    }

    void copyToAndClear(FactActionBuffer other) {
        this.typedQueues.values().forEach((? super T queue) -> ((ActionQueue)queue).queue.forEachDataEntry(a -> other.add(a.action, a.handle, a.getDelta())));
        this.clear();
    }

    void newUpdate(FactHandle handle, FactRecord previous, Object updatedFact) {
        this.add(Action.UPDATE, handle, FactRecordDelta.updateDelta(previous, updatedFact));
    }

    void newInsert(FactHandle handle, FactRecord record) {
        this.add(Action.INSERT, handle, FactRecordDelta.insertDelta(record));
    }

    public void forEach(Consumer<AtomicMemoryAction> consumer) {
        this.typedQueues.values().forEach((? super T q) -> q.forEachDataEntry(consumer));
    }

    public ReIterator<AtomicMemoryAction> actions(Type<?> type) {
        return this.get(type).queue.iterator();
    }

    public void forEach(Type<?> t, Consumer<AtomicMemoryAction> consumer) {
        this.get(t).forEachDataEntry(consumer);
    }

    void newDelete(FactHandle handle, FactRecord record) {
        this.add(Action.RETRACT, handle, FactRecordDelta.deleteDelta(record));
    }

    private static class ActionQueue {
        private static final BiPredicate<AtomicMemoryAction, FactHandle> SEARCH_FUNCTION = (existing, factHandle) -> existing.handle.equals(factHandle);
        private final LinearHashSet<AtomicMemoryAction> queue = new LinearHashSet();

        ActionQueue() {
        }

        synchronized AtomicMemoryAction get(FactHandle factHandle) {
            return this.queue.get((AtomicMemoryAction)((Object)factHandle), SEARCH_FUNCTION);
        }

        synchronized void forEachDataEntry(Consumer<AtomicMemoryAction> consumer) {
            this.queue.forEachDataEntry(consumer);
        }

        synchronized boolean add(Action action, FactHandle factHandle, FactRecordDelta delta) {
            return this.queue.computeIfAbsent((AtomicMemoryAction)((Object)factHandle), SEARCH_FUNCTION, handle -> new AtomicMemoryAction(action, (FactHandle)handle, delta), existingAction -> existingAction.rebuild(action, delta));
        }

        synchronized void clear() {
            this.queue.clear();
        }
    }
}

