/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.evrete.KnowledgeService;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.Imports;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.api.ValuesPredicate;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.EvaluatorStorageImpl;
import org.evrete.runtime.FieldsKey;
import org.evrete.runtime.MemoryAddress;
import org.evrete.runtime.MetaChangeListener;
import org.evrete.runtime.TypeMemoryMetaData;
import org.evrete.runtime.evaluation.EvaluatorWrapper;
import org.evrete.util.TypeResolverWrapper;
import org.evrete.util.TypeWrapper;

abstract class RuntimeMetaData<C extends RuntimeContext<C>>
implements RuntimeContext<C>,
MetaChangeListener,
TypeResolver {
    private static final Comparator<ActiveField> DEFAULT_FIELD_COMPARATOR = Comparator.comparing(ActiveField::getValueIndex);
    private final Imports imports;
    private final Map<String, Object> properties;
    private final ArrayOf<TypeMemoryMetaData> typeMetas;
    private final ArrayOf<FieldsKey> memoryKeys;
    private final EvaluatorStorageImpl evaluators;
    private final AtomicInteger bucketIds;
    private TypeResolver typeResolver;

    RuntimeMetaData(KnowledgeService service, TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        this.imports = service.getConfiguration().getImports().copyOf();
        this.typeMetas = new ArrayOf<TypeMemoryMetaData>(TypeMemoryMetaData.class);
        this.memoryKeys = new ArrayOf<FieldsKey>(FieldsKey.class);
        this.properties = new ConcurrentHashMap<String, Object>();
        this.evaluators = new EvaluatorStorageImpl();
        this.bucketIds = new AtomicInteger(0);
    }

    RuntimeMetaData(RuntimeMetaData<?> parent) {
        this.typeResolver = (TypeResolver)parent.typeResolver.copyOf();
        this.imports = parent.imports.copyOf();
        this.evaluators = parent.evaluators.copyOf();
        this.bucketIds = new AtomicInteger(parent.bucketIds.get());
        this.properties = new ConcurrentHashMap<String, Object>(parent.properties);
        this.memoryKeys = new ArrayOf<FieldsKey>(parent.memoryKeys);
        this.typeMetas = new ArrayOf<TypeMemoryMetaData>(TypeMemoryMetaData.class);
        parent.typeMetas.forEach((meta, i) -> this.typeMetas.set(i, meta.copyOf(this.evaluators, this.bucketIds, this)));
    }

    EvaluatorStorageImpl getEvaluators() {
        return this.evaluators;
    }

    @Override
    @Deprecated
    public final void wrapTypeResolver(TypeResolverWrapper wrapper) {
        this.typeResolver = wrapper;
    }

    @Override
    public final TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public EvaluatorHandle addEvaluator(Evaluator evaluator, double complexity) {
        return this.evaluators.save(evaluator, complexity);
    }

    EvaluatorWrapper getEvaluatorWrapper(EvaluatorHandle handle, boolean returnNull) {
        return this.evaluators.get(handle, returnNull);
    }

    @Override
    public Evaluator getEvaluator(EvaluatorHandle handle) {
        EvaluatorWrapper wrapper = this.getEvaluatorWrapper(handle, true);
        return wrapper == null ? null : wrapper.getDelegate();
    }

    @Override
    public void replaceEvaluator(EvaluatorHandle handle, Evaluator newEvaluator) {
        this.evaluators.replace(handle, newEvaluator);
    }

    @Override
    public void replaceEvaluator(EvaluatorHandle handle, ValuesPredicate predicate) {
        this.evaluators.replace(handle, predicate);
    }

    @Override
    public void addListener(EvaluationListener listener) {
        this.evaluators.addListener(listener);
    }

    @Override
    public void removeListener(EvaluationListener listener) {
        this.evaluators.removeListener(listener);
    }

    TypeMemoryMetaData getTypeMeta(int type) {
        return this.typeMetas.computeIfAbsent(type, k -> new TypeMemoryMetaData(type, this.evaluators, this.bucketIds, (MetaChangeListener)this));
    }

    private ActiveField getCreateActiveField(TypeField field) {
        TypeMemoryMetaData meta = this.getTypeMeta(field.getDeclaringType().getId());
        return meta.getCreate(field);
    }

    synchronized MemoryAddress buildMemoryAddress(Type<?> type, Set<TypeField> fields, Set<EvaluatorHandle> alphaEvaluators) {
        TypeMemoryMetaData typeMeta = this.getTypeMeta(type.getId());
        FieldsKey fieldsKey = this.getCreateMemoryKey(type, fields);
        return typeMeta.buildAlphaMask(fieldsKey, alphaEvaluators);
    }

    private ActiveField[] getCreate(Set<TypeField> fields) {
        HashSet set = new HashSet(fields.size());
        fields.forEach(f -> set.add(this.getCreateActiveField((TypeField)f)));
        ActiveField[] activeFields = set.toArray(ActiveField.ZERO_ARRAY);
        Arrays.sort(activeFields, DEFAULT_FIELD_COMPARATOR);
        return activeFields;
    }

    private FieldsKey getCreateMemoryKey(Type<?> type, Set<TypeField> fields) {
        Object[] activeFields = fields.isEmpty() ? ActiveField.ZERO_ARRAY : this.getCreate(fields);
        for (int i = 0; i < this.memoryKeys.length(); ++i) {
            FieldsKey key = this.memoryKeys.getChecked(i);
            if (!Arrays.equals(key.getFields(), activeFields) || type.getId() != key.type()) continue;
            return key;
        }
        int newId = this.memoryKeys.length();
        FieldsKey newKey = new FieldsKey(newId, type, (ActiveField[])activeFields);
        this.memoryKeys.set(newId, newKey);
        return newKey;
    }

    @Override
    public final C addImport(String imp) {
        this.imports.add(imp);
        return (C)this;
    }

    @Override
    public Imports getImports() {
        return this.imports;
    }

    @Override
    public final C set(String property, Object value) {
        this.properties.put(property, value);
        return (C)this;
    }

    @Override
    public final <T> T get(String property) {
        return (T)this.properties.get(property);
    }

    @Override
    public final Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public abstract ExpressionResolver getExpressionResolver();

    @Override
    public TypeResolver copyOf() {
        return (TypeResolver)this.typeResolver.copyOf();
    }

    @Override
    public <T> Type<T> getType(String name) {
        return this.typeResolver.getType(name);
    }

    @Override
    public <T> Type<T> getType(int typeId) {
        return this.typeResolver.getType(typeId);
    }

    @Override
    public Collection<Type<?>> getKnownTypes() {
        return this.typeResolver.getKnownTypes();
    }

    @Override
    public void wrapType(TypeWrapper<?> typeWrapper) {
        this.typeResolver.wrapType(typeWrapper);
    }

    @Override
    public <T> Type<T> declare(String typeName, Class<T> javaType) {
        return this.typeResolver.declare(typeName, javaType);
    }

    @Override
    public <T> Type<T> declare(String typeName, String javaType) {
        return this.typeResolver.declare(typeName, javaType);
    }

    @Override
    public <T> Type<T> resolve(Object o) {
        return this.typeResolver.resolve(o);
    }
}

