/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.collections.LinearHashSet;
import org.evrete.spi.minimal.IntToValueHandle;
import org.evrete.spi.minimal.LinkedFactHandles;
import org.evrete.spi.minimal.MemoryKeyHashed;
import org.evrete.util.CollectionUtils;

abstract class AbstractFactsMap<K extends MemoryKey> {
    private static final ReIterator<FactHandleVersioned> EMPTY = CollectionUtils.emptyReIterator();
    private final LinearHashSet<FactsWithKey<K>> data;
    private final BiPredicate<FactsWithKey<K>, MemoryKeyHashed> search;
    private final BiPredicate<FactsWithKey<K>, K> SEARCH_PREDICATE = (entry, memoryKey) -> entry.key.equals(memoryKey);
    private final Function<FactsWithKey<K>, MemoryKey> ENTRY_MAPPER = entry -> entry.key;

    AbstractFactsMap() {
        this.search = (key, memoryKey) -> this.sameData((FactsWithKey<K>)key, memoryKey.values);
        this.data = new LinearHashSet();
    }

    abstract boolean sameData(FactsWithKey<K> var1, IntToValueHandle var2);

    abstract K newKeyInstance(MemoryKeyHashed var1);

    final ReIterator<MemoryKey> keys() {
        return this.data.iterator(this.ENTRY_MAPPER);
    }

    public void add(MemoryKeyHashed key, Collection<FactHandleVersioned> factHandles) {
        FactsWithKey entry = this.data.computeIfAbsent((FactsWithKey<MemoryKeyHashed>)((Object)key), this.search, k -> new FactsWithKey<K>(this.newKeyInstance((MemoryKeyHashed)k)));
        for (FactHandleVersioned h : factHandles) {
            entry.facts.add(h);
        }
    }

    final boolean hasKey(MemoryKeyHashed key) {
        return this.data.contains((FactsWithKey<MemoryKeyHashed>)((Object)key), this.search);
    }

    final ReIterator<FactHandleVersioned> values(MemoryKey k) {
        FactsWithKey<K> entry = this.data.get((FactsWithKey<MemoryKey>)((Object)k), this.SEARCH_PREDICATE);
        return entry == null ? EMPTY : entry.facts.iterator();
    }

    final void merge(AbstractFactsMap<K> other) {
        this.merge(other.data);
    }

    final void merge(LinearHashSet<FactsWithKey<K>> data) {
        this.data.addAll(data, (local, external) -> {
            if (local == null || local.isDeleted()) {
                return external;
            }
            local.facts.consume(external.facts);
            return local;
        });
        data.clear();
    }

    public final void clear() {
        this.data.clear();
    }

    public final String toString() {
        return this.data.toString();
    }

    static class FactsWithKey<K extends MemoryKey> {
        final LinkedFactHandles facts = new LinkedFactHandles();
        final K key;

        FactsWithKey(K key) {
            this.key = key;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FactsWithKey factsWithKey = (FactsWithKey)o;
            return this.key.equals(factsWithKey.key);
        }

        boolean isDeleted() {
            return this.key.getMetaValue() == -1;
        }

        public final int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key + "={" + this.facts + '}';
        }
    }
}

