/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.FieldValue;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyedFactStorage;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.spi.minimal.AbstractFactsMap;
import org.evrete.spi.minimal.MemoryKeyHashed;
import org.evrete.util.CollectionUtils;

abstract class AbstractKeyedFactStorage<K extends MemoryKey, T extends AbstractFactsMap<K>>
implements KeyedFactStorage {
    private final T[] maps;
    private MemoryKeyHashed currentRecord = null;

    AbstractKeyedFactStorage(Class<T> mapType, Function<KeyMode, T> mapSupplier) {
        this.maps = (AbstractFactsMap[])CollectionUtils.array(mapType, KeyMode.values().length);
        for (KeyMode mode : KeyMode.values()) {
            this.maps[mode.ordinal()] = (AbstractFactsMap)mapSupplier.apply(mode);
        }
    }

    abstract MemoryKeyHashed writeKey(FieldValue var1);

    @Override
    public final void commitChanges() {
        T main = this.get(KeyMode.OLD_OLD);
        ((AbstractFactsMap)main).merge(this.get(KeyMode.NEW_NEW));
        ((AbstractFactsMap)main).merge(this.get(KeyMode.OLD_NEW));
    }

    @Override
    public final ReIterator<FactHandleVersioned> values(KeyMode mode, MemoryKey key) {
        return ((AbstractFactsMap)this.get(mode)).values(key);
    }

    @Override
    public final void clear() {
        for (T map : this.maps) {
            ((AbstractFactsMap)map).clear();
        }
    }

    private void insert(MemoryKeyHashed key, Collection<FactHandleVersioned> factHandles) {
        if (((AbstractFactsMap)this.get(KeyMode.OLD_OLD)).hasKey(key)) {
            ((AbstractFactsMap)this.get(KeyMode.OLD_NEW)).add(key, factHandles);
        } else {
            ((AbstractFactsMap)this.get(KeyMode.NEW_NEW)).add(key, factHandles);
        }
    }

    @Override
    public void write(FieldValue partialKey) {
        this.currentRecord = this.writeKey(partialKey);
    }

    @Override
    public void write(Collection<FactHandleVersioned> factHandles) {
        this.insert(this.currentRecord, factHandles);
        this.currentRecord = null;
    }

    @Override
    public final ReIterator<MemoryKey> keys(KeyMode keyMode) {
        return ((AbstractFactsMap)this.get(keyMode)).keys();
    }

    final T get(KeyMode mode) {
        return this.maps[mode.ordinal()];
    }

    public String toString() {
        return Arrays.toString(this.maps);
    }
}

