/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Logger;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.collections.ArrayOf;
import org.evrete.spi.minimal.TypeImpl;
import org.evrete.util.TypeWrapper;

class DefaultTypeResolver
implements TypeResolver {
    private static final Logger LOGGER = Logger.getLogger(DefaultTypeResolver.class.getName());
    private final Map<String, Type<?>> typeDeclarationMap = new HashMap();
    private final Map<Integer, Type<?>> typesById = new HashMap();
    private final Map<String, ArrayOf<Type<?>>> typesByJavaType = new HashMap();
    private final Map<String, TypeCacheEntry> typeInheritanceCache = new HashMap<String, TypeCacheEntry>();
    private final ClassLoader classLoader;
    private int fieldSetsCounter = 0;

    DefaultTypeResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private DefaultTypeResolver(DefaultTypeResolver other) {
        this.classLoader = other.classLoader;
        this.fieldSetsCounter = other.fieldSetsCounter;
        for (Map.Entry<String, Type<?>> entry : other.typeDeclarationMap.entrySet()) {
            Type clonedType = (Type)entry.getValue().copyOf();
            this.typeDeclarationMap.put(entry.getKey(), clonedType);
            this.typesById.put(clonedType.getId(), clonedType);
        }
        for (Type type : this.typeDeclarationMap.values()) {
            String javaType = type.getJavaType();
            this.typesByJavaType.computeIfAbsent(javaType, s -> new ArrayOf<Type>(new Type[0])).append(type);
        }
        for (Map.Entry entry : other.typesByJavaType.entrySet()) {
            this.typesByJavaType.put((String)entry.getKey(), new ArrayOf((ArrayOf)entry.getValue()));
        }
    }

    private static Class<?> primitiveClassForName(String className) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return null;
    }

    @Override
    public <T> Type<T> getType(int typeId) {
        Type<?> t = this.typesById.get(typeId);
        if (t == null) {
            throw new NoSuchElementException("No type found with id=" + typeId);
        }
        return t;
    }

    @Override
    public <T> Type<T> getType(String name) {
        return this.typeDeclarationMap.get(name);
    }

    @Override
    public synchronized void wrapType(TypeWrapper<?> typeWrapper) {
        Type<?> delegate = typeWrapper.getDelegate();
        String typeName = typeWrapper.getName();
        int typeId = typeWrapper.getId();
        Type prev = this.typeDeclarationMap.put(typeName, typeWrapper);
        if (prev != delegate) {
            throw new IllegalStateException(typeWrapper + " wraps an unknown type");
        }
        prev = this.typesById.put(typeId, typeWrapper);
        if (prev != delegate) {
            throw new IllegalStateException(typeWrapper + " wraps an unknown type");
        }
        ArrayOf<Type<?>> byJavaTypes = this.typesByJavaType.get(typeWrapper.getJavaType());
        if (byJavaTypes == null) {
            throw new IllegalStateException();
        }
        boolean changed = false;
        for (int i = 0; i < byJavaTypes.length(); ++i) {
            if (byJavaTypes.get(i) != delegate) continue;
            byJavaTypes.set(i, typeWrapper);
            changed = true;
            break;
        }
        if (!changed) {
            throw new IllegalStateException();
        }
    }

    private <T> Class<T> classForName(String javaType) {
        try {
            Class<?> clazz = DefaultTypeResolver.primitiveClassForName(javaType);
            if (clazz == null) {
                clazz = this.classLoader.loadClass(javaType);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public synchronized <T> Type<T> declare(String typeName, String javaType) {
        return this.saveNewType(typeName, new TypeImpl(typeName, javaType, this.newId(), () -> {
            Class resolvedJavaType = this.classForName(javaType);
            if (resolvedJavaType == null) {
                throw new IllegalStateException("Unable to resolve Java class '" + javaType + "'");
            }
            return resolvedJavaType;
        }));
    }

    @Override
    public synchronized <T> Type<T> declare(String typeName, Class<T> javaType) {
        return this.saveNewType(typeName, new TypeImpl(typeName, javaType.getName(), this.newId(), () -> javaType));
    }

    private int newId() {
        return this.typeDeclarationMap.size();
    }

    private <T> Type<T> saveNewType(String typeName, Type<T> type) {
        if (this.typeDeclarationMap.put(typeName, type) == null) {
            this.typesById.put(type.getId(), type);
            this.typesByJavaType.computeIfAbsent(type.getJavaType(), k -> new ArrayOf<Type>(new Type[0])).append(type);
            this.typeInheritanceCache.clear();
            return type;
        }
        throw new IllegalStateException("Type name '" + typeName + "' has been already defined");
    }

    @Override
    public Collection<Type<?>> getKnownTypes() {
        return Collections.unmodifiableCollection(this.typeDeclarationMap.values());
    }

    private Type<?> findInSuperClasses(Class<?> type) {
        ArrayList matched = new ArrayList(this.typeDeclarationMap.size());
        for (Type<?> t : this.typeDeclarationMap.values()) {
            if (!t.resolveJavaType().isAssignableFrom(type)) continue;
            matched.add(t);
        }
        switch (matched.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Type)matched.iterator().next();
            }
        }
        LOGGER.warning("Unable to resolve type '" + type + "' due to ambiguity.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Type<T> resolve(Object o) {
        Objects.requireNonNull(o);
        Class<?> javaType = o.getClass();
        String name = javaType.getName();
        ArrayOf<Type<?>> associatedTypes = this.typesByJavaType.get(name);
        if (associatedTypes != null) {
            if (associatedTypes.length() > 1) {
                LOGGER.warning("Ambiguous type declaration found, there are " + associatedTypes.length() + " types associated with the '" + name + "' Java type, returning <null>.");
                return null;
            }
            return associatedTypes.get(0);
        }
        TypeCacheEntry cacheEntry = this.typeInheritanceCache.get(name);
        if (cacheEntry == null) {
            DefaultTypeResolver defaultTypeResolver = this;
            synchronized (defaultTypeResolver) {
                cacheEntry = this.typeInheritanceCache.get(name);
                if (cacheEntry == null) {
                    cacheEntry = new TypeCacheEntry(this.findInSuperClasses(javaType));
                    this.typeInheritanceCache.put(name, cacheEntry);
                }
            }
        }
        return (TypeImpl)cacheEntry.type;
    }

    @Override
    public DefaultTypeResolver copyOf() {
        return new DefaultTypeResolver(this);
    }

    private static class TypeCacheEntry {
        private final Type<?> type;

        TypeCacheEntry(Type<?> resolved) {
            this.type = resolved;
        }
    }
}

