/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;

public abstract class AbstractRule
implements Rule {
    private static final Logger LOGGER = Logger.getLogger(AbstractRule.class.getName());
    private final String name;
    private final Consumer<RhsContext> NULL_RHS = arg -> LOGGER.warning("No RHS is set for rule '" + this.name + '\'');
    protected Consumer<RhsContext> rhs = this.NULL_RHS;
    private int salience;
    private final Map<String, Object> properties;

    protected AbstractRule(String name, int defaultSalience) {
        this.name = name;
        this.properties = new ConcurrentHashMap<String, Object>();
        this.salience = defaultSalience;
    }

    protected AbstractRule(AbstractRule other) {
        this.name = other.name;
        this.rhs = other.rhs;
        this.properties = new ConcurrentHashMap<String, Object>();
        this.properties.putAll(other.properties);
        this.salience = other.salience;
    }

    @Override
    public final int getSalience() {
        return this.salience;
    }

    @Override
    public void setSalience(int salience) {
        this.salience = salience;
    }

    @Override
    public final <T> void setProperty(String name, T value) {
        this.properties.put(name, value);
    }

    @Override
    public final <T> T getProperty(String name) {
        return (T)this.properties.get(name);
    }

    @Override
    public final <T> T getProperty(String name, T defaultValue) {
        return (T)this.properties.getOrDefault(name, defaultValue);
    }

    @Override
    public final Consumer<RhsContext> getRhs() {
        return this.rhs;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public Rule setRhs(Consumer<RhsContext> rhs) {
        this.rhs = rhs == null ? this.NULL_RHS : rhs;
        return this;
    }
}

