/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.evrete.api.spi.CollectionsService;
import org.evrete.api.spi.CollectionsServiceProvider;
import org.evrete.api.spi.ExpressionResolver;
import org.evrete.api.spi.ExpressionResolverProvider;
import org.evrete.api.spi.ResolverService;
import org.evrete.api.spi.ResolverServiceProvider;

public class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());
    private static final boolean DEFAULT_USE_REFLECTION = true;
    private static final boolean DEFAULT_ORDERED_EXECUTION = false;
    private static final int DEFAULT_EXPECTED_OBJECT_COUNT = 262144;
    private static final int DEFAULT_SESSION_POOL_SIZE = 16;
    private static final int DEFAULT_MEMORY_BUFFER_CAPACITY = 256;
    private static final int DEFAULT_CYCLE_LIMIT = 1024;
    private static final boolean DEFAULT_WARN_UNKNOWN_TYPES = true;
    private final ClassLoader classLoader;
    private final CollectionsService collectionsService;
    private final ExpressionResolver expressionResolver;
    private final ResolverService resolverService;
    private boolean useReflection = true;
    private int expectedObjectCount = 262144;
    private int memoryBufferCapacity = 256;
    private long cycleLimit = 1024L;
    private boolean orderedExecution = false;
    private boolean warnUnknownTypes = true;
    private boolean entryNodeCachingEnabled = true;

    private Configuration(ClassLoader classLoader, Properties properties) {
        this.classLoader = classLoader;
        this.collectionsService = Configuration.loadService(CollectionsServiceProvider.class).instance(properties);
        this.expressionResolver = Configuration.loadService(ExpressionResolverProvider.class).instance(properties, classLoader);
        this.resolverService = Configuration.loadService(ResolverServiceProvider.class).instance();
    }

    private Configuration(Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), properties);
    }

    public Configuration() {
        this(Thread.currentThread().getContextClassLoader(), new Properties());
    }

    private static <Z extends Comparable<Z>> Z loadService(Class<Z> clazz) {
        LinkedList providers = new LinkedList();
        Iterator<Z> sl = ServiceLoader.load(clazz).iterator();
        sl.forEachRemaining(providers::add);
        Collections.sort(providers);
        if (providers.isEmpty()) {
            throw new IllegalStateException();
        }
        return (Z)((Comparable)providers.iterator().next());
    }

    public boolean isWarnUnknownTypes() {
        return this.warnUnknownTypes;
    }

    public Configuration setWarnUnknownTypes(boolean warnUnknownTypes) {
        this.warnUnknownTypes = warnUnknownTypes;
        return this;
    }

    public ResolverService getResolverService() {
        return this.resolverService;
    }

    public boolean isEntryNodeCachingEnabled() {
        return this.entryNodeCachingEnabled;
    }

    public void setEntryNodeCachingEnabled(boolean entryNodeCachingEnabled) {
        this.entryNodeCachingEnabled = entryNodeCachingEnabled;
    }

    public CollectionsService getCollectionsService() {
        return this.collectionsService;
    }

    public ExpressionResolver getExpressionsService() {
        return this.expressionResolver;
    }

    public boolean isOrderedExecution() {
        return this.orderedExecution;
    }

    public Configuration setOrderedExecution(boolean orderedExecution) {
        this.orderedExecution = orderedExecution;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isUseReflection() {
        return this.useReflection;
    }

    public void setUseReflection(boolean useReflection) {
        this.useReflection = useReflection;
    }

    int getMemoryBufferCapacity() {
        return this.memoryBufferCapacity;
    }

    public void setMemoryBufferCapacity(int memoryBufferCapacity) {
        this.memoryBufferCapacity = memoryBufferCapacity;
    }

    public int getExpectedObjectCount() {
        return this.expectedObjectCount;
    }

    public void setExpectedObjectCount(int expectedObjectCount) {
        this.expectedObjectCount = expectedObjectCount;
    }

    public long getCycleLimit() {
        return this.cycleLimit;
    }

    public Configuration setCycleLimit(long cycleLimit) {
        if (cycleLimit < 2L) {
            LOGGER.warning("Cycle limit too low, rules might not work as expected");
        }
        this.cycleLimit = cycleLimit;
        return this;
    }
}

