/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.runtime.AbstractLhsDescriptor;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.LhsDescriptor;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RhsFactGroupIterator;
import org.evrete.runtime.RhsKeysGroupIterator;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.BetaEndNode;

public abstract class AbstractRuntimeLhs {
    private final Collection<BetaEndNode> endNodes = new ArrayList<BetaEndNode>();
    private final AbstractLhsDescriptor descriptor;
    private final AbstractRuntimeLhs parent;
    private final Map<ConditionNodeDescriptor, BetaEndNode> betaEndNodeMap = new HashMap<ConditionNodeDescriptor, BetaEndNode>();
    final RuntimeFact[][] factState;
    private final ValueRow[][] keyState;
    final boolean hasBetaNodes;
    private final RhsFactGroupIterator[] factGroupIterators;
    private final RhsKeysGroupIterator[] keyIterators;
    private final RhsFactGroupIterator looseFactGroupIterator;
    private final Runnable factIterator;
    private final RhsFactGroupIterator lastFactGroupIterator;
    private final Runnable keyIterator;
    private final RhsKeysGroupIterator lastKeyIterator;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    AbstractRuntimeLhs(RuntimeRuleImpl rule, AbstractRuntimeLhs parent, AbstractLhsDescriptor descriptor) {
        this.descriptor = descriptor;
        this.parent = parent;
        for (RhsFactGroupDescriptor groupDescriptor : descriptor.getAllFactGroups()) {
            ConditionNodeDescriptor finalNode = groupDescriptor.getFinalNode();
            if (finalNode == null) continue;
            BetaEndNode endNode = new BetaEndNode(rule, finalNode);
            this.endNodes.add(endNode);
            this.betaEndNodeMap.put(finalNode, endNode);
        }
        RhsFactGroupDescriptor[] allFactGroups = descriptor.getAllFactGroups();
        this.factGroupIterators = new RhsFactGroupIterator[allFactGroups.length];
        this.keyIterators = new RhsKeysGroupIterator[descriptor.getBetaFactGroupCount()];
        this.keyState = new ValueRow[descriptor.getBetaFactGroupCount()][];
        this.factState = new RuntimeFact[allFactGroups.length][];
        RhsFactGroupIterator looseIterator = null;
        for (int i = 0; i < allFactGroups.length; ++i) {
            RhsFactGroupDescriptor groupDescriptor;
            groupDescriptor = allFactGroups[i];
            int factGroupId = groupDescriptor.getFactGroupIndex();
            assert (factGroupId == i);
            FactType[] types = groupDescriptor.getTypes();
            this.factState[factGroupId] = new RuntimeFact[types.length];
            RhsFactGroupIterator groupIterator = new RhsFactGroupIterator(factGroupId, this.factState);
            if (groupDescriptor.isLooseGroup()) {
                groupIterator.setIterables(rule.resolve(types));
                if (looseIterator != null) throw new IllegalStateException();
                looseIterator = groupIterator;
            } else {
                RhsKeysGroupIterator iterator;
                ReIterator<ValueRow[]> deltaIterator;
                ReIterator<ValueRow[]> mainIterator;
                ConditionNodeDescriptor finalNode = groupDescriptor.getFinalNode();
                if (finalNode != null) {
                    BetaEndNode endNode = this.resolve(finalNode);
                    mainIterator = endNode.mainIterator();
                    deltaIterator = endNode.deltaIterator();
                } else {
                    assert (types.length == 1);
                    RuntimeFactTypeKeyed runtimeFactType = (RuntimeFactTypeKeyed)rule.resolve(types[0]);
                    mainIterator = runtimeFactType.mainIterator();
                    deltaIterator = runtimeFactType.deltaIterator();
                }
                int keyGroupId = groupDescriptor.getKeyGroupIndex();
                this.keyIterators[keyGroupId] = iterator = RhsKeysGroupIterator.factory(keyGroupId, groupDescriptor, groupIterator, mainIterator, deltaIterator, this.keyState);
                if (keyGroupId > 0) {
                    RhsKeysGroupIterator prev = this.keyIterators[keyGroupId - 1];
                    prev.setRunnable(iterator);
                }
            }
            this.factGroupIterators[factGroupId] = groupIterator;
            if (i <= 0) continue;
            RhsFactGroupIterator prev = this.factGroupIterators[i - 1];
            prev.setDelegate(groupIterator);
        }
        this.looseFactGroupIterator = looseIterator;
        this.factIterator = this.factGroupIterators[0];
        this.lastFactGroupIterator = this.factGroupIterators[this.factGroupIterators.length - 1];
        if (this.keyIterators.length > 0) {
            this.keyIterator = this.keyIterators[0];
            this.lastKeyIterator = this.keyIterators[this.keyIterators.length - 1];
        } else {
            this.keyIterator = null;
            this.lastKeyIterator = null;
        }
        this.hasBetaNodes = this.keyIterators.length > 0;
    }

    void addStateKeyPredicate(RhsFactGroupDescriptor descriptor, BooleanSupplier predicate) {
        this.keyIterators[descriptor.getKeyGroupIndex()].addStateKeyPredicate(predicate);
    }

    RhsKeysGroupIterator resolve(RhsFactGroupDescriptor descriptor) {
        return this.keyIterators[descriptor.getKeyGroupIndex()];
    }

    public ValueRow[][] getKeyState() {
        return this.keyState;
    }

    public RhsFactGroupIterator getLooseFactGroupIterator() {
        return this.looseFactGroupIterator;
    }

    AbstractRuntimeLhs(RuntimeRuleImpl rule, LhsDescriptor descriptor) {
        this(rule, null, descriptor);
    }

    public RhsKeysGroupIterator[] getKeyGroupIterators() {
        return this.keyIterators;
    }

    void forEachKey(Runnable r) {
        this.lastKeyIterator.setRunnable(r);
        this.keyIterator.run();
    }

    void forEachFact(Runnable r) {
        this.lastFactGroupIterator.setDelegate(r);
        this.factIterator.run();
    }

    public final BetaEndNode resolve(ConditionNodeDescriptor descriptor) {
        AbstractRuntimeLhs current = this;
        while (current != null) {
            BetaEndNode node = this.betaEndNodeMap.get(descriptor);
            if (node != null) {
                return node;
            }
            current = current.parent;
        }
        throw new IllegalArgumentException("Node not found or the argument is not an end-node");
    }

    Collection<BetaEndNode> getEndNodes() {
        return this.endNodes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{descriptor=" + this.descriptor + '}';
    }
}

