/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import org.evrete.AbstractRule;
import org.evrete.api.ValueRow;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeFactTypeKeyed;
import org.evrete.runtime.memory.SessionMemory;

public abstract class AbstractRuntimeRule
extends AbstractRule {
    private final RuntimeFactType[] factSources;
    private final RuntimeFactTypeKeyed[] betaFactSources;
    private final SessionMemory memory;
    private final Function<FactType, Predicate<ValueRow>> deletedKeys;

    AbstractRuntimeRule(RuleDescriptor descriptor, SessionMemory memory) {
        super(descriptor);
        this.memory = memory;
        FactType[] allFactTypes = descriptor.getLhs().getAllFactTypes();
        this.factSources = AbstractRuntimeRule.buildTypes(memory, allFactTypes);
        this.deletedKeys = factType -> {
            RuntimeFactTypeKeyed t = (RuntimeFactTypeKeyed)this.factSources[factType.getInRuleIndex()];
            return valueRow -> t.getKeyStorage().isKeyDeleted((ValueRow)valueRow);
        };
        ArrayList<RuntimeFactTypeKeyed> betaNodes = new ArrayList<RuntimeFactTypeKeyed>(this.factSources.length);
        for (RuntimeFactType t : this.factSources) {
            if (!t.isBetaNode()) continue;
            betaNodes.add((RuntimeFactTypeKeyed)t);
        }
        this.betaFactSources = betaNodes.toArray(new RuntimeFactTypeKeyed[0]);
    }

    public Function<FactType, Predicate<ValueRow>> getDeletedKeys() {
        return this.deletedKeys;
    }

    private static RuntimeFactType[] buildTypes(SessionMemory runtime, FactType[] allFactTypes) {
        RuntimeFactType[] factSources = new RuntimeFactType[allFactTypes.length];
        for (FactType factType : allFactTypes) {
            RuntimeFactType iterable;
            factSources[iterable.getInRuleIndex()] = iterable = RuntimeFactType.factory(factType, runtime);
        }
        return factSources;
    }

    public <T extends RuntimeFactType> T resolve(FactType type) {
        return (T)this.factSources[type.getInRuleIndex()];
    }

    public RuntimeFactType[] resolve(FactType[] types) {
        RuntimeFactType[] resolved = new RuntimeFactType[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolved[i] = this.resolve(types[i]);
        }
        return resolved;
    }

    public RuntimeFactType[] getAllFactTypes() {
        return this.factSources;
    }

    public boolean isInsertDeltaAvailable() {
        boolean delta = false;
        for (RuntimeFactTypeKeyed ft : this.betaFactSources) {
            if (!ft.isInsertDeltaAvailable()) continue;
            delta = true;
        }
        return delta;
    }

    public boolean isDeleteDeltaAvailable() {
        boolean delta = false;
        for (RuntimeFactTypeKeyed ft : this.betaFactSources) {
            if (!ft.isDeleteDeltaAvailable()) continue;
            delta = true;
        }
        return delta;
    }

    public SessionMemory getMemory() {
        return this.memory;
    }

    @Override
    public final void setSalience(int salience) {
        super.setSalience(salience);
        this.memory.reSortRules();
    }
}

