/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.BooleanSupplier;
import org.evrete.api.EachRunnable;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RhsFactGroupIterator;

public abstract class RhsKeysGroupIterator
implements EachRunnable,
Runnable {
    private static final BooleanSupplier TRUE_PREDICATE = () -> true;
    private final ReIterator<ValueRow[]> mainIterator;
    private final ReIterator<ValueRow[]> deltaIterator;
    private final RhsFactGroupIterator groupIterator;
    private Runnable runnable;
    private final ValueRow[][] state;
    private final int keyGroupId;
    private BooleanSupplier statePredicate = TRUE_PREDICATE;

    RhsKeysGroupIterator(int keyGroupId, RhsFactGroupIterator groupIterator, ReIterator<ValueRow[]> mainIterator, ReIterator<ValueRow[]> deltaIterator, ValueRow[][] state) {
        this.mainIterator = mainIterator;
        this.deltaIterator = deltaIterator;
        this.groupIterator = groupIterator;
        this.keyGroupId = keyGroupId;
        this.state = state;
    }

    static RhsKeysGroupIterator factory(int keyGroupId, RhsFactGroupDescriptor groupDescriptor, RhsFactGroupIterator groupIterator, ReIterator<ValueRow[]> mainIterator, ReIterator<ValueRow[]> deltaIterator, ValueRow[][] state) {
        return groupDescriptor.isAllUniqueKeysAndAlpha() ? new WithIterators(keyGroupId, groupIterator, mainIterator, deltaIterator, state) : new WithIterables(keyGroupId, groupIterator, mainIterator, deltaIterator, state);
    }

    @Override
    public void run() {
        this.runForEach(this.runnable);
    }

    public void addStateKeyPredicate(BooleanSupplier predicate) {
        if (this.statePredicate == TRUE_PREDICATE) {
            this.statePredicate = predicate;
        } else {
            BooleanSupplier old = this.statePredicate;
            this.statePredicate = () -> old.getAsBoolean() && predicate.getAsBoolean();
        }
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public ReIterator<ValueRow[]> getMainIterator() {
        return this.mainIterator;
    }

    public ReIterator<ValueRow[]> getDeltaIterator() {
        return this.deltaIterator;
    }

    @Override
    public void runForEach(Runnable r) {
        if (this.mainIterator.reset() == 0L) {
            return;
        }
        while (this.mainIterator.hasNext()) {
            this.state[this.keyGroupId] = (ValueRow[])this.mainIterator.next();
            ValueRow[] next = this.state[this.keyGroupId];
            if (!this.statePredicate.getAsBoolean()) continue;
            this.initFactIterators(next);
            this.runnable.run();
        }
    }

    void setFactIterables(ValueRow[] next) {
        this.groupIterator.setIterables(next);
    }

    void setFactIterators(ValueRow[] next) {
        this.groupIterator.setIterators(next);
    }

    abstract void initFactIterators(ValueRow[] var1);

    private static class WithIterators
    extends RhsKeysGroupIterator {
        WithIterators(int keyGroupId, RhsFactGroupIterator groupIterator, ReIterator<ValueRow[]> mainIterator, ReIterator<ValueRow[]> deltaIterator, ValueRow[][] state) {
            super(keyGroupId, groupIterator, mainIterator, deltaIterator, state);
        }

        @Override
        void initFactIterators(ValueRow[] next) {
            this.setFactIterators(next);
        }
    }

    private static class WithIterables
    extends RhsKeysGroupIterator {
        WithIterables(int keyGroupId, RhsFactGroupIterator groupIterator, ReIterator<ValueRow[]> mainIterator, ReIterator<ValueRow[]> deltaIterator, ValueRow[][] state) {
            super(keyGroupId, groupIterator, mainIterator, deltaIterator, state);
        }

        @Override
        void initFactIterators(ValueRow[] next) {
            this.setFactIterables(next);
        }
    }
}

