/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import org.evrete.api.IntToValue;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.runtime.AbstractRuntimeLhs;
import org.evrete.runtime.AggregateEvaluator;
import org.evrete.runtime.AggregateLhsDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FactTypeField;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RhsKeysGroupIterator;
import org.evrete.runtime.RuntimeAggregateLhs;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.evaluation.EvaluatorInternal;

public class RuntimeAggregateLhsJoined
extends RuntimeAggregateLhs {
    private final ValueRow[][] state;
    private final SourceIterator[] iterators;
    private final EvaluatorInternal[] evaluators;
    private final IntToValue[] evaluatorValues;
    private final KeysStore successData;
    private final IntFunction<IntToValueRow> saveMapper;
    private final BooleanSupplier aggregateKeyPredicate;
    private final int[][][] saveMapping;
    private final AggregateLhsDescriptor descriptor;

    public RuntimeAggregateLhsJoined(RuntimeRuleImpl rule, AbstractRuntimeLhs parent, AggregateLhsDescriptor descriptor) {
        super(rule, parent, descriptor);
        int allFactTypes = rule.getAllFactTypes().length;
        this.descriptor = descriptor;
        AggregateEvaluator aggregateEvaluator = descriptor.getJoinCondition();
        this.evaluators = descriptor.getJoinCondition().getEvaluators();
        this.evaluatorValues = new IntToValue[this.evaluators.length];
        AbstractRuntimeLhs[] allLhs = new AbstractRuntimeLhs[]{parent, this};
        this.saveMapping = new int[allLhs.length][][];
        AggregateEvaluator.LevelData[] levelData = aggregateEvaluator.getLevelData();
        int[] groupingSizes = new int[levelData.length];
        int totalGroups = 0;
        for (int level2 = 0; level2 < levelData.length; ++level2) {
            AggregateEvaluator.LevelData data = levelData[level2];
            FactType[] types = data.getFactTypeSequence();
            this.saveMapping[level2] = new int[types.length][];
            groupingSizes[level2] = types.length;
            totalGroups += data.getKeyGroupSequence().length;
        }
        this.iterators = new SourceIterator[totalGroups];
        this.state = new ValueRow[this.iterators.length][];
        int iteratorIndex = 0;
        for (int level3 = 0; level3 < levelData.length; ++level3) {
            RhsFactGroupDescriptor[] groupDescriptors;
            SourceIterator[] data = levelData[level3];
            int inLevelIndex = 0;
            for (RhsFactGroupDescriptor d : groupDescriptors = data.getKeyGroupSequence()) {
                FactType[] types;
                for (FactType t : types = d.getTypes()) {
                    this.saveMapping[level3][inLevelIndex] = new int[]{iteratorIndex, t.getInGroupIndex()};
                    ++inLevelIndex;
                }
                this.iterators[iteratorIndex] = new SourceIterator(iteratorIndex, d, allLhs[level3].resolve(d));
                ++iteratorIndex;
            }
        }
        this.successData = rule.getMemory().newKeysStore(groupingSizes);
        this.saveMapper = level -> typeIndex -> {
            int[] addr = this.saveMapping[level][typeIndex];
            return this.state[addr[0]][addr[1]];
        };
        int[][] conditionMapping = new int[allFactTypes][];
        for (SourceIterator iterator : this.iterators) {
            int t = 0;
            while (t < iterator.types.length) {
                FactType type = iterator.types[t];
                int typeId = type.getInRuleIndex();
                assert (conditionMapping[typeId] == null);
                conditionMapping[typeId] = new int[]{iterator.index, t++};
            }
        }
        for (int i = 0; i < this.evaluators.length; ++i) {
            this.evaluatorValues[i] = new IntToValueImpl(this.evaluators[i], this.state, conditionMapping);
        }
        this.aggregateKeyPredicate = descriptor.getAggregateEvaluatorFactory().joinedGroupEvaluator(parent, this);
    }

    public BooleanSupplier getAggregateKeyPredicate() {
        return this.aggregateKeyPredicate;
    }

    public KeysStore getSuccessData() {
        return this.successData;
    }

    public AggregateLhsDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void evaluate(boolean deltaOnly) {
        this.evaluate(0, false, deltaOnly);
    }

    private void evaluate(int index, boolean hasDelta, boolean deltaOnly) {
        SourceIterator iterator = this.iterators[index];
        if (index == this.iterators.length - 1) {
            ReIterator<ValueRow[]> it = iterator.main();
            it.reset();
            while (it.hasNext() && (!deltaOnly || hasDelta)) {
                this.state[index] = (ValueRow[])it.next();
                this.testAndSave();
            }
            it = iterator.delta();
            it.reset();
            while (it.hasNext()) {
                this.state[index] = (ValueRow[])it.next();
                this.testAndSave();
            }
        } else {
            ReIterator<ValueRow[]> it = iterator.main();
            it.reset();
            while (it.hasNext()) {
                this.state[index] = (ValueRow[])it.next();
                this.evaluate(index + 1, hasDelta, deltaOnly);
            }
            it = iterator.delta();
            it.reset();
            while (it.hasNext()) {
                this.state[index] = (ValueRow[])it.next();
                this.evaluate(index + 1, true, deltaOnly);
            }
        }
    }

    private void testAndSave() {
        for (int i = 0; i < this.evaluators.length; ++i) {
            if (this.evaluators[i].test(this.evaluatorValues[i])) continue;
            return;
        }
        this.successData.save(this.saveMapper);
    }

    static class SourceIterator {
        private final FactType[] types;
        private final int index;
        private final ReIterator<ValueRow[]> main;
        private final ReIterator<ValueRow[]> delta;

        SourceIterator(int index, RhsFactGroupDescriptor descriptor, RhsKeysGroupIterator iterator) {
            this.types = descriptor.getTypes();
            this.index = index;
            this.main = iterator.getMainIterator();
            this.delta = iterator.getDeltaIterator();
        }

        ReIterator<ValueRow[]> main() {
            return this.main;
        }

        ReIterator<ValueRow[]> delta() {
            return this.delta;
        }
    }

    private static class IntToValueImpl
    implements IntToValue {
        private final ValueRow[][] state;
        private final int[][] addr;

        IntToValueImpl(EvaluatorInternal evaluator, ValueRow[][] state, int[][] conditionMapping) {
            this.state = state;
            FactTypeField[] descriptor = evaluator.descriptor();
            this.addr = new int[descriptor.length][];
            for (int value = 0; value < this.addr.length; ++value) {
                FactTypeField ref = descriptor[value];
                FactType factType = ref.getFactType();
                int[] map = conditionMapping[factType.getInRuleIndex()];
                this.addr[value] = new int[]{map[0], map[1], ref.getFieldIndex()};
            }
        }

        @Override
        public Object apply(int value) {
            int[] map = this.addr[value];
            return this.state[map[0]][map[1]].get(map[2]);
        }
    }
}

