/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.api.spi.SharedBetaFactStorage;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.memory.SessionMemory;

public class RuntimeFactTypeKeyed
extends RuntimeFactType {
    private final SharedBetaFactStorage keyStorage;

    public RuntimeFactTypeKeyed(SessionMemory runtime, FactType other) {
        super(runtime, other);
        this.keyStorage = runtime.getBetaFactStorage(other);
    }

    public RuntimeFactTypeKeyed(RuntimeFactTypeKeyed other) {
        super(other.getRuntime(), other);
        this.keyStorage = other.keyStorage;
    }

    @Override
    boolean isBetaNode() {
        return true;
    }

    public ReIterator<ValueRow[]> mainIterator() {
        return this.keyStorage.main().keyIterator();
    }

    public ReIterator<ValueRow[]> deltaIterator() {
        return this.keyStorage.delta().keyIterator();
    }

    public SharedBetaFactStorage getKeyStorage() {
        return this.keyStorage;
    }

    @Override
    public boolean isInsertDeltaAvailable() {
        return this.keyStorage.delta().keyCount() > 0L;
    }

    @Override
    public boolean isDeleteDeltaAvailable() {
        return this.keyStorage.hasDeletedKeys();
    }

    @Override
    public ReIterator<RuntimeFact> iterator() {
        throw new UnsupportedOperationException();
    }
}

