/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeFact;
import org.evrete.api.TypeResolver;
import org.evrete.runtime.AbstractRuntimeLhs;
import org.evrete.runtime.AggregateLhsDescriptor;
import org.evrete.runtime.LhsDescriptor;
import org.evrete.runtime.MemoryChangeListener;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeAggregateLhs;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeAggregateLhsLoose;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.memory.Action;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.runtime.memory.Buffer;

public class RuntimeLhs
extends AbstractRuntimeLhs
implements RhsContext,
MemoryChangeListener {
    private final Collection<RuntimeAggregateLhsLoose> aggregateLooseGroups = new ArrayList<RuntimeAggregateLhsLoose>();
    private final Collection<RuntimeAggregateLhsJoined> aggregateConditionedGroups = new ArrayList<RuntimeAggregateLhsJoined>();
    private final BetaEndNode[] allBetaEndNodes;
    private final Function<String, int[]> name2indices;
    private final Buffer buffer;
    private final TypeResolver typeResolver;

    private RuntimeLhs(RuntimeRuleImpl rule, LhsDescriptor descriptor, Buffer buffer) {
        super(rule, descriptor);
        this.name2indices = descriptor.getNameIndices();
        this.buffer = buffer;
        this.typeResolver = rule.getMemory().getTypeResolver();
        ArrayList<BetaEndNode> allBetas = new ArrayList<BetaEndNode>(this.getEndNodes());
        for (AggregateLhsDescriptor ad : descriptor.getAggregateDescriptors()) {
            RuntimeAggregateLhs aggregate;
            if (ad.isLoose()) {
                RuntimeAggregateLhsLoose loose = new RuntimeAggregateLhsLoose(rule, (AbstractRuntimeLhs)this, ad);
                this.aggregateLooseGroups.add(loose);
                aggregate = loose;
            } else {
                RuntimeAggregateLhsJoined conditioned = new RuntimeAggregateLhsJoined(rule, (AbstractRuntimeLhs)this, ad);
                this.aggregateConditionedGroups.add(conditioned);
                RhsFactGroupDescriptor[] myGroups = ad.getJoinCondition().getLevelData()[0].getKeyGroupSequence();
                this.addStateKeyPredicate(myGroups[myGroups.length - 1], conditioned.getAggregateKeyPredicate());
                aggregate = conditioned;
            }
            allBetas.addAll(aggregate.getEndNodes());
        }
        this.allBetaEndNodes = allBetas.toArray(BetaEndNode.ZERO_ARRAY);
    }

    static RuntimeLhs factory(RuntimeRuleImpl rule, LhsDescriptor descriptor, Buffer buffer) {
        return new RuntimeLhs(rule, descriptor, buffer);
    }

    public Collection<RuntimeAggregateLhsJoined> getAggregateConditionedGroups() {
        return this.aggregateConditionedGroups;
    }

    private boolean testLooseGroups() {
        for (RuntimeAggregateLhsLoose group : this.aggregateLooseGroups) {
            if (group.getAsBoolean()) continue;
            return false;
        }
        return true;
    }

    public void forEach(Consumer<RhsContext> rhs) {
        this.forEach(() -> rhs.accept(this));
    }

    private void forEach(Runnable eachFactRunnable) {
        if (this.testLooseGroups()) {
            if (this.hasBetaNodes) {
                this.forEachKey(() -> this.forEachFact(eachFactRunnable));
            } else {
                this.forEachFact(eachFactRunnable);
            }
        }
    }

    public BetaEndNode[] getAllBetaEndNodes() {
        return this.allBetaEndNodes;
    }

    @Override
    public RuntimeFact getFact(String name) {
        int[] arr = this.name2indices.apply(name);
        if (arr == null) {
            throw new IllegalArgumentException("Unknown type reference: " + name);
        }
        return this.factState[arr[0]][arr[1]];
    }

    @Override
    public RhsContext update(Object obj) {
        this.buffer.add(this.typeResolver, Action.UPDATE, Collections.singleton(obj));
        return this;
    }

    @Override
    public RhsContext delete(Object obj) {
        this.buffer.add(this.typeResolver, Action.RETRACT, Collections.singleton(obj));
        return this;
    }

    @Override
    public RhsContext insert(Object obj) {
        this.buffer.add(this.typeResolver, Action.INSERT, Collections.singleton(obj));
        return this;
    }
}

