/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.function.Consumer;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeRule;
import org.evrete.runtime.AbstractRuntimeRule;
import org.evrete.runtime.MemoryChangeListener;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeLhs;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.runtime.memory.Buffer;
import org.evrete.runtime.memory.SessionMemory;

public class RuntimeRuleImpl
extends AbstractRuntimeRule
implements MemoryChangeListener,
RuntimeRule {
    private final RuntimeLhs lhs;
    private final Buffer ruleBuffer = new Buffer();
    private final Buffer memoryBuffer;

    public RuntimeRuleImpl(RuleDescriptor rd, SessionMemory memory) {
        super(rd, memory);
        this.memoryBuffer = memory.getBuffer();
        this.lhs = RuntimeLhs.factory(this, rd.getLhs(), this.ruleBuffer);
    }

    @Override
    public final void executeRhs() {
        this.lhs.forEach(this.rhs);
        this.memoryBuffer.takeAllFrom(this.ruleBuffer);
    }

    @Override
    public final RuntimeRuleImpl setRhs(Consumer<RhsContext> consumer) {
        super.setRhs(consumer);
        return this;
    }

    @Override
    public void onAfterChange() {
        this.resetState();
    }

    private void resetState() {
        for (BetaEndNode endNode : this.lhs.getAllBetaEndNodes()) {
            endNode.mergeDelta();
        }
    }

    public BetaEndNode[] getAllBetaEndNodes() {
        return this.lhs.getAllBetaEndNodes();
    }

    public Collection<RuntimeAggregateLhsJoined> getAggregateLhsGroups() {
        return this.lhs.getAggregateConditionedGroups();
    }
}

