/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.api.Named;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.runtime.FireContext;
import org.evrete.runtime.KnowledgeImpl;
import org.evrete.runtime.memory.SessionMemory;

public class StatefulSessionImpl
extends SessionMemory
implements StatefulSession {
    private final KnowledgeImpl knowledge;
    private final long cycleLimit;
    private final boolean ordered;
    private boolean active = true;

    StatefulSessionImpl(KnowledgeImpl knowledge) {
        super(knowledge);
        this.knowledge = knowledge;
        this.cycleLimit = this.getConfiguration().getCycleLimit();
        this.ordered = this.getConfiguration().isOrderedExecution();
    }

    @Override
    public RuntimeRule getRule(String name) {
        return Named.find(this.getRules(), name);
    }

    @Override
    public void close() {
        if (this.active) {
            this.active = false;
            super.destroy();
            this.knowledge.close(this);
        }
    }

    @Override
    public void fire() {
        this.checkState();
        FireContext ctx = new FireContext(this);
        if (this.ordered) {
            this.fireOrdered(ctx);
        } else {
            this.fireUnOrdered(ctx);
        }
    }

    private void fireOrdered(FireContext ctx) {
        this.doEvaluationTasks(ctx);
        for (RuntimeRule r : this.getRules()) {
            r.executeRhs();
            if (!this.hasMemoryTasks()) continue;
            this.fireOrdered(ctx);
        }
    }

    private void fireUnOrdered(FireContext ctx) {
        this.doEvaluationTasks(ctx);
        for (RuntimeRule r : this.getRules()) {
            r.executeRhs();
        }
        if (this.hasMemoryTasks()) {
            this.fireUnOrdered(ctx);
        }
    }

    private void doEvaluationTasks(FireContext ctx) {
        int cycle = ctx.incrementFireCount();
        if ((long)cycle > this.cycleLimit) {
            throw new IllegalStateException("Cycling limit of [" + this.cycleLimit + "] is reached. You might want to check the rules or increase the limit in configuration.");
        }
        this.handleBuffer();
    }

    private void checkState() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }
}

