/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountedCompleter;
import java.util.function.Predicate;
import org.evrete.api.KeysStore;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.NodeCleanTask;
import org.evrete.runtime.async.ValueRowPredicate;
import org.evrete.runtime.memory.BetaConditionNode;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.util.Bits;

public class BetaMemoryDeleteTask
extends Completer {
    private final RuntimeRuleImpl rule;

    public BetaMemoryDeleteTask(Completer parent, RuntimeRuleImpl rule) {
        super(parent);
        this.rule = rule;
    }

    @Override
    protected void execute() {
        Bits deleteMask = new Bits();
        HashSet<BetaEndNode> betaEndNodes = new HashSet<BetaEndNode>();
        for (BetaEndNode endNode : this.rule.getAllBetaEndNodes()) {
            for (RuntimeFactType factType : endNode.getEntryNodes()) {
                if (!factType.isDeleteDeltaAvailable()) continue;
                deleteMask.set(factType.getInRuleIndex());
                betaEndNodes.add(endNode);
            }
        }
        this.tailCall(betaEndNodes, (Z g) -> new NodeCleanTask(this, (BetaConditionNode)g, this.rule, deleteMask));
    }

    @Override
    public void onCompletion(CountedCompleter<?> caller) {
        Collection<RuntimeAggregateLhsJoined> aggregateNodes = this.rule.getAggregateLhsGroups();
        if (aggregateNodes.isEmpty()) {
            return;
        }
        ArrayList<Runnable> aggregateTasks = new ArrayList<Runnable>(aggregateNodes.size());
        for (RuntimeAggregateLhsJoined node : aggregateNodes) {
            aggregateTasks.add(() -> {
                KeysStore subject = node.getSuccessData();
                FactType[][] grouping = node.getDescriptor().getJoinCondition().getGrouping();
                Predicate[] predicates = ValueRowPredicate.predicates(grouping, this.rule.getDeletedKeys());
                subject.delete(predicates);
            });
            Completer.of(aggregateTasks).invoke();
        }
    }
}

