/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import org.evrete.runtime.async.Completer;

public class ForkJoinExecutor {
    private final ForkJoinPool delegate;
    private static final AtomicInteger poolCounter = new AtomicInteger(0);

    public ForkJoinExecutor() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ForkJoinExecutor(int parallelism) {
        this.delegate = new ForkJoinPool(parallelism, new EvreteForkJoinWorkerThreadFactory(), null, false);
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public void invoke(Completer task) {
        this.delegate.invoke(task);
    }

    static /* synthetic */ AtomicInteger access$000() {
        return poolCounter;
    }

    private static final class EvreteForkJoinWorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final AtomicInteger threadCounter = new AtomicInteger();
        private final int poolId = ForkJoinExecutor.access$000().getAndIncrement();

        EvreteForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new EvreteWorkerThread(pool, this.poolId, this.threadCounter);
        }
    }

    private static class EvreteWorkerThread
    extends ForkJoinWorkerThread {
        private static final String THREAD_NAME_FORMAT = "evrete-pool-%d-thread-%d";

        EvreteWorkerThread(ForkJoinPool pool, int poolId, AtomicInteger threadCounter) {
            super(pool);
            this.setName(String.format(THREAD_NAME_FORMAT, poolId, threadCounter.incrementAndGet()));
        }
    }
}

