/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.Arrays;
import org.evrete.api.RuntimeFact;
import org.evrete.runtime.evaluation.AlphaEvaluator;

public abstract class AlphaBucketMeta {
    private static final AlphaEvaluator[] EMPTY_INDICES = new AlphaEvaluator[0];
    private static final boolean[] EMPTY_VALUES = new boolean[0];
    static final AlphaBucketMeta NO_FIELDS_NO_CONDITIONS = new AlphaBucketMeta(-777, EMPTY_INDICES, EMPTY_VALUES){

        @Override
        public boolean test(RuntimeFact fact) {
            throw new UnsupportedOperationException();
        }
    };
    private final int bucketIndex;
    private final AlphaEvaluator[] alphaEvaluators;
    private final boolean[] requiredValues;
    private final int hash;

    private AlphaBucketMeta(int bucketIndex, AlphaEvaluator[] alphaEvaluators, boolean[] requiredValues) {
        this.bucketIndex = bucketIndex;
        this.alphaEvaluators = alphaEvaluators;
        this.requiredValues = requiredValues;
        this.hash = AlphaBucketMeta.hash(alphaEvaluators, requiredValues);
    }

    public boolean test(RuntimeFact fact) {
        boolean[] tests = fact.getAlphaTests();
        for (AlphaEvaluator e : this.alphaEvaluators) {
            int i = e.getUniqueId();
            if (tests[i] == this.requiredValues[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.alphaEvaluators.length == 0;
    }

    static AlphaBucketMeta factory(int bucketIndex, AlphaEvaluator[] alphaConditions, boolean[] requiredValues) {
        if (alphaConditions.length == 0) {
            return new Empty(bucketIndex);
        }
        return new Default(bucketIndex, alphaConditions, requiredValues);
    }

    boolean sameData(AlphaEvaluator[] alphaEvaluators, boolean[] requiredValues) {
        return AlphaBucketMeta.sameData(this.alphaEvaluators, this.requiredValues, alphaEvaluators, requiredValues);
    }

    public final int getBucketIndex() {
        return this.bucketIndex;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlphaBucketMeta that = (AlphaBucketMeta)o;
        return this.hash == that.hash && AlphaBucketMeta.sameData(this, that);
    }

    public final int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "{bucket=" + this.bucketIndex + ", indices=" + Arrays.toString(this.alphaEvaluators) + ", values=" + Arrays.toString(this.requiredValues) + '}';
    }

    private static boolean sameData(AlphaEvaluator[] alphaEvaluators1, boolean[] values1, AlphaEvaluator[] alphaEvaluators2, boolean[] values2) {
        if (!Arrays.equals(alphaEvaluators1, alphaEvaluators2)) {
            return false;
        }
        for (int i = 0; i < alphaEvaluators1.length; ++i) {
            int alphaIdx2;
            boolean b2;
            int alphaIdx1 = alphaEvaluators1[i].getUniqueId();
            boolean b1 = values1[alphaIdx1];
            if (b1 == (b2 = values2[alphaIdx2 = alphaEvaluators2[i].getUniqueId()])) continue;
            return false;
        }
        return true;
    }

    private static boolean sameData(AlphaBucketMeta ai1, AlphaBucketMeta ai2) {
        return AlphaBucketMeta.sameData(ai1.alphaEvaluators, ai1.requiredValues, ai2.alphaEvaluators, ai2.requiredValues);
    }

    private static int hash(AlphaEvaluator[] alphaIndices, boolean[] requiredValues) {
        int h = 0;
        for (AlphaEvaluator e : alphaIndices) {
            int i = e.getUniqueId();
            h += Integer.hashCode(i) + Boolean.hashCode(requiredValues[i]);
        }
        return h;
    }

    private static final class Empty
    extends AlphaBucketMeta {
        Empty(int bucketIndex) {
            super(bucketIndex, EMPTY_INDICES, EMPTY_VALUES);
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final boolean test(RuntimeFact fact) {
            return true;
        }
    }

    private static final class Default
    extends AlphaBucketMeta {
        Default(int bucketIndex, AlphaEvaluator[] alphaEvaluators, boolean[] requiredValues) {
            super(bucketIndex, alphaEvaluators, requiredValues);
        }
    }
}

