/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.function.Predicate;
import org.evrete.api.ActiveField;
import org.evrete.api.Evaluator;
import org.evrete.api.LogicallyComparable;
import org.evrete.runtime.builder.FieldReference;

public class AlphaEvaluator
implements LogicallyComparable,
Predicate<Object> {
    private final Evaluator delegate;
    private final int uniqueId;
    private final int valueIndex;

    AlphaEvaluator(int uniqueId, Evaluator e, ActiveField field) {
        this.uniqueId = uniqueId;
        this.delegate = e;
        this.valueIndex = field.getValueIndex();
        FieldReference[] descriptor = e.descriptor();
        if (descriptor.length != 1) {
            throw new IllegalStateException();
        }
    }

    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public int compare(LogicallyComparable other) {
        if (other instanceof AlphaEvaluator) {
            AlphaEvaluator ap = (AlphaEvaluator)other;
            if (this.equals(ap)) {
                return 1;
            }
            return this.delegate.compare(ap.delegate);
        }
        return 0;
    }

    @Override
    public boolean test(Object o) {
        return this.delegate.test(value -> o);
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    Evaluator getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return "{id=" + this.uniqueId + ", delegate=" + this.delegate + '}';
    }
}

