/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.evrete.api.Evaluator;
import org.evrete.api.NamedType;
import org.evrete.runtime.FactType;
import org.evrete.runtime.FactTypeField;
import org.evrete.runtime.builder.FieldReference;
import org.evrete.runtime.evaluation.EvaluatorGroup;
import org.evrete.runtime.evaluation.EvaluatorInternal;
import org.evrete.util.MapOfSet;

public final class EvaluatorFactory {
    public static List<EvaluatorGroup> flattenEvaluators(Collection<Evaluator> rawEvaluators, Function<NamedType, FactType> typeFunction) {
        Collection<EvaluatorInternal> evaluators = EvaluatorFactory.convert(rawEvaluators, typeFunction);
        MapOfSet<Set, Set> groupedConditions = new MapOfSet<Set, Set>();
        for (EvaluatorInternal e : evaluators) {
            Set set = Arrays.stream(e.descriptor()).map(FactTypeField::getFactType).collect(Collectors.toSet());
            groupedConditions.computeIfAbsent(set, k -> new HashSet()).add(e);
        }
        ArrayList<EvaluatorGroup> result = new ArrayList<EvaluatorGroup>(groupedConditions.size());
        for (Map.Entry entry : groupedConditions.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            result.add(EvaluatorFactory.flattenEvaluators(collection));
        }
        return result;
    }

    private static Collection<EvaluatorInternal> convert(Collection<Evaluator> rawEvaluators, Function<NamedType, FactType> typeFunction) {
        ArrayList<EvaluatorInternal> evaluators = new ArrayList<EvaluatorInternal>(rawEvaluators.size());
        for (Evaluator e : rawEvaluators) {
            EvaluatorFactory.validateExpression(e);
            evaluators.add(new EvaluatorInternal(e, typeFunction));
        }
        return evaluators;
    }

    private static EvaluatorGroup flattenEvaluators(Collection<EvaluatorInternal> collection) {
        assert (collection.size() > 0);
        return new EvaluatorGroup(collection);
    }

    public static EvaluatorGroup unionEvaluators(Collection<Evaluator> raw, Function<NamedType, FactType> typeFunction) {
        Collection<EvaluatorInternal> collection = EvaluatorFactory.convert(raw, typeFunction);
        return new EvaluatorGroup(collection);
    }

    private static void validateExpression(Evaluator expression) {
        int refCount = expression.descriptor().length;
        HashSet<FieldReference> fields = new HashSet<FieldReference>(Arrays.asList(expression.descriptor()));
        if (fields.size() != refCount) {
            throw new UnsupportedOperationException("Duplicate field references like in 'a + a + b > 3' are currently not supported, please declare a new Type.Field instead.");
        }
    }
}

