/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.ArrayList;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.collections.MappedReIterator;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.evaluation.EvaluatorGroup;
import org.evrete.runtime.memory.BetaConditionNode;
import org.evrete.runtime.memory.BetaMemoryNode;
import org.evrete.runtime.memory.SessionMemory;

public class AbstractBetaConditionNode
implements BetaMemoryNode<ConditionNodeDescriptor> {
    private final int[] nonPlainSourceIndices;
    private final KeysStore mainStore;
    private final KeysStore deltaStore;
    private final EvaluatorGroup expression;
    private final ConditionNodeDescriptor descriptor;
    private final BetaMemoryNode<?>[] sources;
    private final BetaConditionNode[] conditionSources;
    private final RuntimeFactType[][] grouping;
    private final RuntimeRuleImpl rule;
    private final ReIterator<ValueRow[]> mainIterator;
    private final ReIterator<ValueRow[]> deltaIterator;

    AbstractBetaConditionNode(RuntimeRuleImpl rule, ConditionNodeDescriptor descriptor, BetaMemoryNode<?>[] sources) {
        this.sources = sources;
        ArrayList<BetaConditionNode> conditionNodeList = new ArrayList<BetaConditionNode>(sources.length);
        for (BetaMemoryNode<?> source : sources) {
            if (!source.isConditionNode()) continue;
            conditionNodeList.add((BetaConditionNode)source);
        }
        this.conditionSources = conditionNodeList.toArray(BetaConditionNode.EMPTY_ARRAY);
        this.rule = rule;
        this.descriptor = descriptor;
        this.nonPlainSourceIndices = descriptor.getNonPlainSourceIndices();
        SessionMemory memory = rule.getMemory();
        this.mainStore = memory.newKeysStore(descriptor.getEvalGrouping());
        this.deltaStore = memory.newKeysStore(descriptor.getEvalGrouping());
        this.expression = descriptor.getExpression();
        FactType[][] descGrouping = descriptor.getEvalGrouping();
        this.grouping = new RuntimeFactType[descGrouping.length][];
        for (int i = 0; i < descGrouping.length; ++i) {
            this.grouping[i] = rule.resolve(descGrouping[i]);
        }
        this.mainIterator = new MappedReIterator<ValueRow[], KeysStore.Entry>(this.mainStore.entries(), KeysStore.Entry::key);
        this.deltaIterator = new MappedReIterator<ValueRow[], KeysStore.Entry>(this.deltaStore.entries(), KeysStore.Entry::key);
    }

    public BetaConditionNode[] getConditionSources() {
        return this.conditionSources;
    }

    public boolean hasMainData() {
        return !this.mainStore.isEmpty();
    }

    @Override
    public KeysStore getDeltaStore() {
        return this.deltaStore;
    }

    public SessionMemory getRuntime() {
        return this.rule.getMemory();
    }

    @Override
    public RuntimeFactType[][] getGrouping() {
        return this.grouping;
    }

    public BetaMemoryNode<?>[] getSources() {
        return this.sources;
    }

    @Override
    public ConditionNodeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int[] getNonPlainSourceIndices() {
        return this.nonPlainSourceIndices;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{condition=" + this.expression + '}';
    }

    @Override
    public KeysStore getMainStore() {
        return this.mainStore;
    }

    public ReIterator<ValueRow[]> mainIterator() {
        return this.mainIterator;
    }

    public ReIterator<ValueRow[]> deltaIterator() {
        return this.deltaIterator;
    }
}

