/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import org.evrete.api.FieldsKey;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.spi.SharedBetaFactStorage;
import org.evrete.collections.ArrayOf;
import org.evrete.runtime.MemoryChangeListener;
import org.evrete.runtime.RuntimeObject;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.FieldsMemoryBucket;
import org.evrete.runtime.memory.SessionMemory;

public class FieldsMemory
implements MemoryChangeListener {
    private final FieldsKey typeFields;
    private final SessionMemory runtime;
    private final ArrayOf<FieldsMemoryBucket> alphaBuckets;

    FieldsMemory(SessionMemory runtime, FieldsKey typeFields) {
        this.runtime = runtime;
        this.typeFields = typeFields;
        this.alphaBuckets = new ArrayOf<FieldsMemoryBucket>(FieldsMemoryBucket.class);
    }

    public SharedBetaFactStorage get(AlphaBucketMeta mask) {
        int bucketIndex = mask.getBucketIndex();
        if (bucketIndex >= ((FieldsMemoryBucket[])this.alphaBuckets.data).length) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        SharedBetaFactStorage storage = ((FieldsMemoryBucket[])this.alphaBuckets.data)[bucketIndex].getFieldData();
        if (storage == null) {
            throw new IllegalArgumentException("No alpha bucket created for " + mask);
        }
        return storage;
    }

    FieldsMemoryBucket touchMemory(AlphaBucketMeta alphaMeta) {
        int bucketIndex = alphaMeta.getBucketIndex();
        if (this.alphaBuckets.isEmptyAt(bucketIndex)) {
            FieldsMemoryBucket newBucket = new FieldsMemoryBucket(this.runtime, this.typeFields, alphaMeta);
            this.alphaBuckets.set(bucketIndex, newBucket);
            return newBucket;
        }
        return null;
    }

    void onNewAlphaBucket(AlphaBucketMeta alphaMeta, ReIterator<RuntimeObject> existingFacts) {
        FieldsMemoryBucket newBucket = this.touchMemory(alphaMeta);
        assert (newBucket != null);
        SharedBetaFactStorage betaFactStorage = newBucket.getFieldData();
        if (existingFacts.reset() > 0L) {
            while (existingFacts.hasNext()) {
                RuntimeObject rto = (RuntimeObject)existingFacts.next();
                if (!alphaMeta.test(rto)) continue;
                betaFactStorage.insertDirect(rto);
            }
        }
    }

    void clear() {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.clear();
        }
    }

    void insert(Collection<RuntimeObject> facts) {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.insert(facts);
        }
    }

    void retract(Collection<RuntimeFact> facts) {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.retract(facts);
        }
    }

    @Override
    public void onAfterChange() {
        for (FieldsMemoryBucket bucket : (FieldsMemoryBucket[])this.alphaBuckets.data) {
            bucket.mergeInsertDelta();
            bucket.mergeDeleteDelta();
        }
    }
}

