/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import org.evrete.api.FieldsKey;
import org.evrete.api.RuntimeFact;
import org.evrete.api.spi.CollectionsService;
import org.evrete.api.spi.SharedBetaFactStorage;
import org.evrete.runtime.RuntimeObject;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.SessionMemory;

class FieldsMemoryBucket {
    private final SharedBetaFactStorage fieldData;
    private final AlphaBucketMeta alphaMask;
    private boolean insertDeltaAvailable = false;
    private boolean deleteDeltaAvailable = false;

    FieldsMemoryBucket(SessionMemory runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
        CollectionsService collectionsService = runtime.getConfiguration().getCollectionsService();
        this.alphaMask = alphaMask;
        this.fieldData = collectionsService.newBetaStorage(typeFields);
    }

    public void clear() {
        this.fieldData.clear();
    }

    SharedBetaFactStorage getFieldData() {
        return this.fieldData;
    }

    void insert(Collection<RuntimeObject> facts) {
        this.fieldData.ensureDeltaCapacity(facts.size());
        for (RuntimeObject fact : facts) {
            if (!this.alphaMask.test(fact) || !this.fieldData.insert(fact)) continue;
            this.insertDeltaAvailable = true;
        }
    }

    void retract(Collection<RuntimeFact> facts) {
        for (RuntimeFact fact : facts) {
            if (!this.alphaMask.test(fact) || !this.fieldData.delete(fact)) continue;
            this.deleteDeltaAvailable = true;
        }
    }

    void mergeInsertDelta() {
        if (this.insertDeltaAvailable) {
            this.fieldData.mergeDelta();
            this.insertDeltaAvailable = false;
        }
    }

    void mergeDeleteDelta() {
        if (this.deleteDeltaAvailable) {
            this.fieldData.clearDeletedKeys();
            this.deleteDeltaAvailable = false;
        }
    }
}

