/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldsKey;
import org.evrete.api.Rule;
import org.evrete.api.RuntimeContext;
import org.evrete.api.RuntimeRule;
import org.evrete.api.StatefulSession;
import org.evrete.api.Type;
import org.evrete.api.WorkingMemory;
import org.evrete.api.spi.SharedBetaFactStorage;
import org.evrete.collections.FastHashMap;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeImpl;
import org.evrete.runtime.MemoryChangeListener;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.RuntimeRules;
import org.evrete.runtime.async.AggregateComputeTask;
import org.evrete.runtime.async.Completer;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.async.RuleHotDeploymentTask;
import org.evrete.runtime.async.RuleMemoryDeleteTask;
import org.evrete.runtime.async.RuleMemoryInsertTask;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaDelta;
import org.evrete.runtime.memory.Action;
import org.evrete.runtime.memory.BufferSafe;
import org.evrete.runtime.memory.TypeMemory;

public class SessionMemory
extends AbstractRuntime<StatefulSession>
implements WorkingMemory,
MemoryChangeListener {
    private final BufferSafe buffer = new BufferSafe();
    private final RuntimeRules ruleStorage = new RuntimeRules(this);
    private final FastHashMap<Type, TypeMemory> typedMemories = new FastHashMap(this.getTypeResolver().getKnownTypes().size());

    protected SessionMemory(KnowledgeImpl parent) {
        super(parent);
        for (RuleDescriptor descriptor : this.getRuleDescriptors()) {
            this.deployRule(descriptor, false);
        }
    }

    public void reSortRules() {
        this.ruleStorage.sort(this.getRuleComparator());
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        super.setRuleComparator(ruleComparator);
        this.reSortRules();
    }

    @Override
    public final RuntimeContext.Kind getKind() {
        return RuntimeContext.Kind.SESSION;
    }

    @Override
    public RuntimeRule deployRule(RuleDescriptor descriptor) {
        return this.deployRule(descriptor, true);
    }

    private synchronized RuntimeRuleImpl deployRule(RuleDescriptor descriptor, boolean hotDeployment) {
        for (FactType factType : descriptor.getLhs().getAllFactTypes()) {
            this.touchMemory(factType.getFields(), factType.getAlphaMask());
        }
        RuntimeRuleImpl rule = this.ruleStorage.addRule(descriptor);
        if (hotDeployment) {
            this.getExecutor().invoke(new RuleHotDeploymentTask(rule));
        }
        return rule;
    }

    private void touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        Type t = key.getType();
        this.typedMemories.computeIfAbsent(t, k -> new TypeMemory(this, t)).touchMemory(key, alphaMeta);
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.typedMemories.forEachValue(TypeMemory::clear);
    }

    @Override
    public final void insert(Collection<?> objects) {
        if (objects == null) {
            return;
        }
        this.buffer.add(this.getTypeResolver(), Action.INSERT, objects);
    }

    @Override
    protected synchronized void onNewActiveField(ActiveField newField) {
        Type t = newField.getDeclaringType();
        TypeMemory tm = (TypeMemory)this.typedMemories.get(t);
        if (tm == null) {
            tm = new TypeMemory(this, t);
            this.typedMemories.put(t, tm);
        } else {
            tm.onNewActiveField(newField);
        }
    }

    @Override
    protected void onNewAlphaBucket(AlphaDelta delta) {
        Type t = delta.getKey().getType();
        TypeMemory tm = (TypeMemory)this.typedMemories.get(t);
        if (tm == null) {
            tm = new TypeMemory(this, t);
            this.typedMemories.put(t, tm);
        } else {
            tm.onNewAlphaBucket(delta);
        }
    }

    public BufferSafe getBuffer() {
        return this.buffer;
    }

    public SharedBetaFactStorage getBetaFactStorage(FactType factType) {
        Type t = factType.getType();
        FieldsKey fields = factType.getFields();
        AlphaBucketMeta mask = factType.getAlphaMask();
        return this.get(t).get(fields).get(mask);
    }

    @Override
    public final void delete(Collection<?> objects) {
        if (objects == null) {
            return;
        }
        this.buffer.add(this.getTypeResolver(), Action.RETRACT, objects);
    }

    @Override
    public void update(Collection<?> objects) {
        if (objects == null) {
            return;
        }
        this.buffer.add(this.getTypeResolver(), Action.UPDATE, objects);
    }

    protected void destroy() {
        this.buffer.clear();
        this.typedMemories.clear();
    }

    @Override
    public <T> void forEachMemoryObject(String type, Consumer<T> consumer) {
        Type t = this.getTypeResolver().getType(type);
        TypeMemory tm = (TypeMemory)this.typedMemories.get(t);
        if (tm != null) {
            tm.forEachMemoryObject(consumer);
        }
    }

    @Override
    public void forEachMemoryObject(Consumer<Object> consumer) {
        this.typedMemories.forEachValue(mem -> mem.forEachObjectUnchecked(consumer));
    }

    public List<RuntimeRule> getRules() {
        return this.ruleStorage.asList();
    }

    protected void handleBuffer() {
        this.onBeforeChange();
        LinkedList<Completer> tasksQueue = new LinkedList<Completer>();
        this.handleDeletes(tasksQueue);
        this.handleInserts(tasksQueue);
        ForkJoinExecutor executor = this.getExecutor();
        for (Completer task : tasksQueue) {
            executor.invoke(task);
        }
        this.onAfterChange();
    }

    @Override
    public void onAfterChange() {
        this.buffer.clear();
        this.ruleStorage.onAfterChange();
        this.typedMemories.forEachValue(MemoryChangeListener::onAfterChange);
    }

    @Override
    public void onBeforeChange() {
        this.ruleStorage.onBeforeChange();
        this.typedMemories.forEachValue(MemoryChangeListener::onBeforeChange);
    }

    private void handleDeletes(List<Completer> tasksQueue) {
        this.buffer.takeAll(Action.RETRACT, (type, iterator) -> {
            TypeMemory tm = this.get((Type)type);
            while (iterator.hasNext()) {
                tm.deleteSingle(iterator.next());
            }
            tm.commitDelete();
        });
        LinkedList<RuntimeRuleImpl> ruleDeleteChanges = new LinkedList<RuntimeRuleImpl>();
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            if (!rule.isDeleteDeltaAvailable()) continue;
            ruleDeleteChanges.add(rule);
        }
        if (!ruleDeleteChanges.isEmpty()) {
            tasksQueue.add(new RuleMemoryDeleteTask(ruleDeleteChanges));
        }
    }

    private void handleInserts(List<Completer> tasksQueue) {
        Collection<RuntimeAggregateLhsJoined> aggregateGroups;
        this.buffer.takeAll(Action.INSERT, (type, iterator) -> {
            TypeMemory tm = this.get((Type)type);
            while (iterator.hasNext()) {
                tm.insertSingle(iterator.next());
            }
            tm.commitInsert();
        });
        LinkedList<RuntimeRuleImpl> ruleInsertChanges = new LinkedList<RuntimeRuleImpl>();
        for (RuntimeRuleImpl rule : this.ruleStorage) {
            if (!rule.isInsertDeltaAvailable()) continue;
            ruleInsertChanges.add(rule);
        }
        if (!ruleInsertChanges.isEmpty()) {
            tasksQueue.add(new RuleMemoryInsertTask(ruleInsertChanges, true));
        }
        if (!(aggregateGroups = this.ruleStorage.getAggregateLhsGroups()).isEmpty()) {
            tasksQueue.add(new AggregateComputeTask(aggregateGroups, true));
        }
    }

    public TypeMemory get(Type t) {
        TypeMemory m = (TypeMemory)this.typedMemories.get(t);
        if (m == null) {
            throw new IllegalArgumentException("No type memory created for " + t);
        }
        return m;
    }

    protected boolean hasMemoryTasks() {
        return this.buffer.hasTasks();
    }
}

