/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import org.evrete.Configuration;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldsKey;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.Type;
import org.evrete.collections.AbstractFastHashMap;
import org.evrete.collections.ArrayOf;
import org.evrete.collections.FastIdentityHashMap;
import org.evrete.runtime.MemoryChangeListener;
import org.evrete.runtime.RuntimeObject;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaConditions;
import org.evrete.runtime.evaluation.AlphaDelta;
import org.evrete.runtime.evaluation.AlphaEvaluator;
import org.evrete.runtime.memory.FieldsMemory;
import org.evrete.runtime.memory.SessionMemory;
import org.evrete.runtime.memory.TypeMemoryBucket;

public final class TypeMemory
implements MemoryChangeListener,
ReIterable<RuntimeFact> {
    private static final Logger LOGGER = Logger.getLogger(TypeMemory.class.getName());
    private final AlphaConditions alphaConditions;
    private final Map<FieldsKey, FieldsMemory> betaMemories = new HashMap<FieldsKey, FieldsMemory>();
    private final SessionMemory runtime;
    private final Type type;
    private final IdentityMap facts;
    private final ArrayOf<TypeMemoryBucket> alphaBuckets;
    private final List<RuntimeObject> insertBuffer = new LinkedList<RuntimeObject>();
    private final List<RuntimeFact> deleteBuffer = new LinkedList<RuntimeFact>();
    private ActiveField[] activeFields;
    private AlphaEvaluator[] alphaEvaluators;

    TypeMemory(SessionMemory runtime, Type type) {
        this.runtime = runtime;
        this.alphaConditions = runtime.getAlphaConditions();
        Configuration conf = runtime.getConfiguration();
        this.type = type;
        this.facts = new IdentityMap(conf);
        this.alphaBuckets = new ArrayOf<TypeMemoryBucket>(TypeMemoryBucket.class);
    }

    public final Set<FieldsKey> knownFieldSets() {
        return Collections.unmodifiableSet(this.betaMemories.keySet());
    }

    void clear() {
        this.facts.clear();
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.clear();
        }
        for (FieldsMemory fm : this.betaMemories.values()) {
            fm.clear();
        }
    }

    public final FieldsMemory get(FieldsKey fields) {
        FieldsMemory fm = this.betaMemories.get(fields);
        if (fm == null) {
            throw new IllegalArgumentException("No key memory exists for " + fields);
        }
        return fm;
    }

    public void forEach(Consumer<RuntimeFact> consumer) {
        this.facts.forEachValue(consumer::accept);
    }

    @Override
    public ReIterator<RuntimeFact> iterator() {
        return this.facts.factIterator();
    }

    public ReIterable<RuntimeFact> get(AlphaBucketMeta alphaMask) {
        if (alphaMask.isEmpty()) {
            return this;
        }
        int bucketIndex = alphaMask.getBucketIndex();
        if (bucketIndex >= ((TypeMemoryBucket[])this.alphaBuckets.data).length) {
            throw new IllegalStateException("No alpha memory initialized for " + alphaMask + ", type: " + this.type);
        }
        TypeMemoryBucket bucket = ((TypeMemoryBucket[])this.alphaBuckets.data)[bucketIndex];
        if (bucket == null) {
            throw new IllegalStateException("No alpha memory initialized for " + alphaMask + ", type: " + this.type);
        }
        return bucket;
    }

    final void commitInsert() {
        if (this.insertBuffer.isEmpty()) {
            return;
        }
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.insert(this.insertBuffer);
        }
        for (FieldsMemory fm : this.fieldsMemories()) {
            fm.insert(this.insertBuffer);
        }
        this.insertBuffer.clear();
    }

    void onNewActiveField(ActiveField newField) {
        ReIterator<RuntimeObject> it = this.facts.factImplIterator();
        while (it.hasNext()) {
            RuntimeObject rto = (RuntimeObject)it.next();
            Object fieldValue = newField.readValue(rto.getDelegate());
            rto.appendValue(newField, fieldValue);
        }
    }

    void touchMemory(FieldsKey key, AlphaBucketMeta alphaMeta) {
        if (key.size() == 0) {
            this.touchAlphaMemory(alphaMeta);
        } else {
            this.betaMemories.computeIfAbsent(key, k -> new FieldsMemory(this.runtime, key)).touchMemory(alphaMeta);
        }
    }

    private TypeMemoryBucket touchAlphaMemory(AlphaBucketMeta alphaMeta) {
        int bucketIndex;
        if (!alphaMeta.isEmpty() && this.alphaBuckets.isEmptyAt(bucketIndex = alphaMeta.getBucketIndex())) {
            TypeMemoryBucket newBucket = new TypeMemoryBucket(this.runtime, alphaMeta);
            this.alphaBuckets.set(bucketIndex, newBucket);
            return newBucket;
        }
        return null;
    }

    void onNewAlphaBucket(AlphaDelta delta) {
        ReIterator<RuntimeObject> existingFacts = this.facts.factImplIterator();
        AlphaEvaluator[] newEvaluators = delta.getNewEvaluators();
        if (newEvaluators.length > 0 && existingFacts.reset() > 0L) {
            while (existingFacts.hasNext()) {
                ((RuntimeObject)existingFacts.next()).appendAlphaTest(newEvaluators);
            }
        }
        FieldsKey key = delta.getKey();
        AlphaBucketMeta alphaMeta = delta.getNewAlphaMeta();
        if (key.size() == 0) {
            TypeMemoryBucket newBucket = this.touchAlphaMemory(alphaMeta);
            assert (newBucket != null);
            if (existingFacts.reset() > 0L) {
                while (existingFacts.hasNext()) {
                    newBucket.insertSingle((RuntimeObject)existingFacts.next());
                }
            }
        } else {
            this.betaMemories.computeIfAbsent(key, k -> new FieldsMemory(this.runtime, key)).onNewAlphaBucket(alphaMeta, existingFacts);
        }
    }

    final void commitDelete() {
        if (this.deleteBuffer.isEmpty()) {
            return;
        }
        for (TypeMemoryBucket bucket : (TypeMemoryBucket[])this.alphaBuckets.data) {
            bucket.retract(this.deleteBuffer);
        }
        for (FieldsMemory fm : this.fieldsMemories()) {
            fm.retract(this.deleteBuffer);
        }
        this.deleteBuffer.clear();
    }

    private Collection<FieldsMemory> fieldsMemories() {
        return this.betaMemories.values();
    }

    void deleteSingle(Object fact) {
        RuntimeFact rtf = (RuntimeFact)this.facts.remove(fact);
        if (rtf != null) {
            this.deleteBuffer.add(rtf);
        }
    }

    @Override
    public void onBeforeChange() {
        this.alphaEvaluators = (AlphaEvaluator[])this.alphaConditions.getPredicates((Type)this.type).data;
        this.activeFields = this.runtime.getActiveFields(this.type);
        for (FieldsMemory fm : this.fieldsMemories()) {
            fm.onBeforeChange();
        }
    }

    @Override
    public void onAfterChange() {
        for (FieldsMemory fm : this.fieldsMemories()) {
            fm.onAfterChange();
        }
    }

    final <T> void forEachMemoryObject(Consumer<T> consumer) {
        this.facts.forEachKey(f -> consumer.accept(f));
    }

    final void forEachObjectUnchecked(Consumer<Object> consumer) {
        this.facts.forEachKey(consumer);
    }

    final void insertSingle(Object o) {
        RuntimeObject rto = this.register(o);
        this.insertBuffer.add(rto);
    }

    private RuntimeObject register(Object o) {
        RuntimeObject rto;
        Object[] values = new Object[this.activeFields.length];
        for (int i = 0; i < this.activeFields.length; ++i) {
            values[i] = this.activeFields[i].readValue(o);
        }
        if (this.alphaEvaluators.length > 0) {
            boolean[] alphaTests = new boolean[this.alphaEvaluators.length];
            for (AlphaEvaluator alpha : this.alphaEvaluators) {
                int fieldInUseIndex = alpha.getValueIndex();
                alphaTests[alpha.getUniqueId()] = alpha.test(values[fieldInUseIndex]);
            }
            rto = RuntimeObject.factory(o, values, alphaTests);
        } else {
            rto = RuntimeObject.factory(o, values);
        }
        if (this.facts.put(o, rto) == null) {
            return rto;
        }
        LOGGER.warning("Object " + o + " has been already inserted, skipping insert");
        return null;
    }

    private static class IdentityMap
    extends FastIdentityHashMap<Object, RuntimeObject> {
        private static final ToIntFunction<Object> HASH = System::identityHashCode;
        private static final Function<AbstractFastHashMap.Entry<Object, RuntimeObject>, RuntimeFact> MAPPER = AbstractFastHashMap.Entry::getValue;
        private static final Function<AbstractFastHashMap.Entry<Object, RuntimeObject>, RuntimeObject> MAPPER_IMPL = AbstractFastHashMap.Entry::getValue;
        private static final BiPredicate<Object, Object> EQ = (fact1, fact2) -> fact1 == fact2;

        IdentityMap(Configuration conf) {
            super(conf.getExpectedObjectCount());
        }

        ReIterator<RuntimeFact> factIterator() {
            return this.iterator(MAPPER);
        }

        ReIterator<RuntimeObject> factImplIterator() {
            return this.iterator(MAPPER_IMPL);
        }

        @Override
        protected ToIntFunction<Object> keyHashFunction() {
            return HASH;
        }

        @Override
        protected BiPredicate<Object, Object> keyHashEquals() {
            return EQ;
        }
    }
}

