/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import org.evrete.api.ReIterable;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.spi.SharedPlainFactStorage;
import org.evrete.runtime.RuntimeObject;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.SessionMemory;

class TypeMemoryBucket
implements ReIterable<RuntimeFact> {
    private final SharedPlainFactStorage data;
    private final AlphaBucketMeta alphaMask;

    TypeMemoryBucket(SessionMemory runtime, AlphaBucketMeta alphaMask) {
        assert (!alphaMask.isEmpty());
        this.data = runtime.getConfiguration().getCollectionsService().newPlainStorage();
        this.alphaMask = alphaMask;
    }

    void clear() {
        this.data.clear();
    }

    void insert(Collection<RuntimeObject> facts) {
        this.data.ensureExtraCapacity(facts.size());
        for (RuntimeObject rto : facts) {
            this.insertSingle(rto);
        }
    }

    void insertSingle(RuntimeObject rto) {
        if (this.alphaMask.test(rto)) {
            this.data.insert(rto);
        }
    }

    void retract(Collection<RuntimeFact> facts) {
        for (RuntimeFact fact : facts) {
            if (!this.alphaMask.test(fact)) continue;
            this.data.delete(fact);
        }
    }

    @Override
    public ReIterator<RuntimeFact> iterator() {
        return this.data.iterator();
    }
}

