/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.api.spi.SharedBetaFactStorage;
import org.evrete.collections.AbstractHashData;
import org.evrete.spi.minimal.ValueRowImpl;

class FieldsFactMap
extends AbstractHashData<ValueRowImpl>
implements SharedBetaFactStorage.Scope {
    private static final ToIntFunction<Object> HASH_FUNCTION = Object::hashCode;
    private static final BiPredicate<ValueRowImpl, ValueRowImpl> EQ_FUNCTION_TYPED = ValueRowImpl::equals;

    FieldsFactMap() {
    }

    @Override
    public ReIterator<ValueRow[]> keyIterator() {
        ValueRowImpl[] arr = new ValueRowImpl[1];
        return this.iterator(vr -> {
            arr[0] = vr;
            return arr;
        });
    }

    @Override
    public final long keyCount() {
        return this.size();
    }

    @Override
    protected ToIntFunction<Object> getHashFunction() {
        return HASH_FUNCTION;
    }

    public void addAll(FieldsFactMap other) {
        this.resize((int)(this.size() + other.size() + 1L));
        other.forEachDataEntry(this::insertOtherNoResize);
    }

    @Override
    protected BiPredicate<Object, Object> getEqualsPredicate() {
        return IDENTITY_EQUALS;
    }

    private void insertOtherNoResize(ValueRowImpl other) {
        int hash = other.hashCode();
        int addr = this.findBinIndex(other, hash, EQ_FUNCTION_TYPED);
        ValueRowImpl found = (ValueRowImpl)this.get(addr);
        if (found == null) {
            this.saveDirect(other, addr);
        } else {
            found.mergeDataFrom(other);
        }
    }

    ValueRowImpl deleteAndTestExisting(RuntimeFact fact, int addr) {
        ValueRowImpl entry = (ValueRowImpl)this.get(addr);
        if (entry == null) {
            return null;
        }
        if (entry.removeFact(fact) == 0L) {
            this.markDeleted(addr);
            return entry;
        }
        return null;
    }
}

