/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.collections.AbstractHashData;
import org.evrete.spi.minimal.MiscUtils;

class KeysStoreMap
extends AbstractHashData<MapEntry>
implements KeysStore {
    private static final BiPredicate<MapEntry, ValueRow[]> EQ_FUNCTION = (entry, rows) -> MiscUtils.sameData(entry.key, rows);
    private static final BiPredicate<MapEntry, IntToValueRow> EQ_FUNCTION1 = (entry, intToValueRow) -> MiscUtils.eqIdentity(intToValueRow, entry.key);
    private static final BiPredicate<Object, Object> EQ_PREDICATE = (o1, o2) -> {
        MapEntry e1 = (MapEntry)o1;
        MapEntry e2 = (MapEntry)o2;
        return e1.eq(e2);
    };
    private static final ToIntFunction<Object> HASH_FUNCTION = value -> ((MapEntry)value).hash;
    private final int level;
    private final Supplier<KeysStore> storeSupplier;
    private final int arrSize;
    private static final Function<MapEntry, KeysStore.Entry> KEY_MAPPER = entry -> entry;

    KeysStoreMap(int level, int arrSize, Supplier<KeysStore> storeSupplier) {
        super(16);
        this.level = level;
        this.arrSize = arrSize;
        this.storeSupplier = storeSupplier;
    }

    @Override
    public KeysStore getNext(IntToValueRow key) {
        int hash = MiscUtils.hash(key, this.arrSize);
        MapEntry e = (MapEntry)this.get(this.findBinIndex(key, hash, EQ_FUNCTION1));
        return e == null ? null : e.next;
    }

    @Override
    public ReIterator<KeysStore.Entry> entries() {
        return this.iterator(KEY_MAPPER);
    }

    @Override
    public long keyCount() {
        return this.size();
    }

    @Override
    protected final ToIntFunction<Object> getHashFunction() {
        return HASH_FUNCTION;
    }

    @Override
    protected final BiPredicate<Object, Object> getEqualsPredicate() {
        return EQ_PREDICATE;
    }

    @Override
    public final <P extends Predicate<IntToValueRow>> void delete(P[] predicates, int index) {
        for (int i = 0; i < this.currentInsertIndex; ++i) {
            int idx = this.getAt(i);
            MapEntry entry = (MapEntry)this.get(idx);
            if (entry == null) continue;
            entry.next.delete((Predicate[])predicates, index + 1);
            ValueRow[] arr = entry.key;
            IntToValueRow iv = z -> arr[z];
            if (!predicates[index].test((IntToValueRow)iv) && !entry.next.isEmpty()) continue;
            this.markDeleted(idx);
        }
    }

    @Override
    public final void save(IntFunction<IntToValueRow> values) {
        this.resize();
        ValueRow[] key = MiscUtils.toArray(values.apply(this.level), this.arrSize);
        int hash = MiscUtils.hash(key);
        int addr = this.findBinIndex(key, hash, EQ_FUNCTION);
        MapEntry found = (MapEntry)this.get(addr);
        if (found == null) {
            found = new MapEntry(key, hash, this.storeSupplier.get());
            this.saveDirect(found, addr);
        }
        found.next.save(values);
    }

    @Override
    public final void append(KeysStore other) {
        this.bulkAdd((KeysStoreMap)other);
    }

    static final class MapEntry
    implements KeysStore.Entry {
        final ValueRow[] key;
        final KeysStore next;
        final int hash;

        MapEntry(ValueRow[] key, int hash, KeysStore next) {
            this.key = key;
            this.next = next;
            this.hash = hash;
        }

        @Override
        public ValueRow[] key() {
            return this.key;
        }

        @Override
        public final KeysStore getNext() {
            return this.next;
        }

        boolean eq(MapEntry other) {
            return MiscUtils.sameData(this.key, other.key);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.eq((MapEntry)o);
        }

        public final int hashCode() {
            return this.hash;
        }

        public String toString() {
            return Arrays.toString(this.key) + "->" + this.next;
        }
    }
}

