/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.evrete.api.IntToValueRow;
import org.evrete.api.KeysStore;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.collections.CollectionReIterator;
import org.evrete.collections.MappedReIterator;
import org.evrete.spi.minimal.MiscUtils;

class KeysStorePlain
implements KeysStore {
    private final ArrayList<ValueRow[]> collection = new ArrayList();
    private final int level;
    private final int arrSize;
    private final ReIterator<ValueRow[]> reIterator;

    KeysStorePlain(int level, int arrSize) {
        this.level = level;
        this.arrSize = arrSize;
        this.reIterator = new CollectionReIterator<ValueRow[]>(this.collection);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public ReIterator<KeysStore.Entry> entries() {
        DummyEntry entry = new DummyEntry();
        return new MappedReIterator<KeysStore.Entry, ValueRow[]>(this.reIterator, entry);
    }

    @Override
    public long keyCount() {
        return this.collection.size();
    }

    @Override
    public void save(IntFunction<IntToValueRow> values) {
        this.collection.add(MiscUtils.toArray(values.apply(this.level), this.arrSize));
    }

    @Override
    public KeysStore getNext(IntToValueRow key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void append(KeysStore store) {
        KeysStorePlain other = (KeysStorePlain)store;
        this.collection.addAll(other.collection);
    }

    public final String toString() {
        StringJoiner j = new StringJoiner(", ");
        for (Object[] objectArray : this.collection) {
            j.add(Arrays.toString(objectArray));
        }
        return j.toString();
    }

    @Override
    public final <P extends Predicate<IntToValueRow>> void delete(P[] predicates, int index) {
        Object p = predicates[index];
        this.collection.removeIf(values -> {
            IntToValueRow iv = i -> values[i];
            return p.test(iv);
        });
    }

    private static class DummyEntry
    implements KeysStore.Entry,
    Function<ValueRow[], KeysStore.Entry> {
        ValueRow[] key;

        private DummyEntry() {
        }

        @Override
        public ValueRow[] key() {
            return this.key;
        }

        @Override
        public KeysStore.Entry apply(ValueRow[] valueRows) {
            this.key = valueRows;
            return this;
        }

        @Override
        public KeysStore getNext() {
            throw new UnsupportedOperationException();
        }
    }
}

