/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import java.util.function.BiPredicate;
import org.evrete.api.ActiveField;
import org.evrete.api.FieldToValue;
import org.evrete.api.FieldsKey;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.api.spi.SharedBetaFactStorage;
import org.evrete.collections.FastHashSet;
import org.evrete.spi.minimal.FieldsFactMap;
import org.evrete.spi.minimal.MiscUtils;
import org.evrete.spi.minimal.ValueRowImpl;

class SharedBetaDataTuple
implements SharedBetaFactStorage {
    private final Object[] reusableValueArr;
    private final FieldsFactMap delta;
    private final FastHashSet<ValueRow> deleteTasks = new FastHashSet();
    private final BiPredicate<ValueRowImpl, Object[]> SHARED_ARRAY_EQ = new BiPredicate<ValueRowImpl, Object[]>(){

        @Override
        public boolean test(ValueRowImpl entry, Object[] values) {
            return MiscUtils.sameData(entry.data, SharedBetaDataTuple.this.reusableValueArr);
        }
    };
    private final FieldsFactMap main;
    private final ActiveField[] fields;

    SharedBetaDataTuple(FieldsKey typeFields) {
        this.delta = new FieldsFactMap();
        this.main = new FieldsFactMap();
        this.fields = typeFields.getFields();
        this.reusableValueArr = new Object[this.fields.length];
    }

    @Override
    public boolean hasDeletedKeys() {
        return this.deleteTasks.size() > 0L;
    }

    @Override
    public boolean isKeyDeleted(ValueRow row) {
        return this.deleteTasks.contains(row);
    }

    @Override
    public void clear() {
        this.delta.clear();
        this.main.clear();
        this.deleteTasks.clear();
    }

    @Override
    public void clearDeletedKeys() {
        this.deleteTasks.clear();
    }

    private int hash(FieldToValue key) {
        int hash = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            this.reusableValueArr[i] = key.apply(this.fields[i]);
            hash ^= this.reusableValueArr[i].hashCode();
        }
        return hash;
    }

    @Override
    public void ensureDeltaCapacity(int insertCount) {
        this.delta.resize((int)(this.delta.size() + (long)insertCount));
    }

    @Override
    public boolean delete(RuntimeFact fact) {
        int hash = this.hash(fact);
        int addr = this.main.findBinIndex(this.reusableValueArr, hash, this.SHARED_ARRAY_EQ);
        ValueRowImpl deleted = this.main.deleteAndTestExisting(fact, addr);
        if (deleted != null) {
            this.deleteTasks.add(deleted);
            return true;
        }
        return false;
    }

    @Override
    public SharedBetaFactStorage.Scope delta() {
        return this.delta;
    }

    @Override
    public SharedBetaFactStorage.Scope main() {
        return this.main;
    }

    @Override
    public boolean insert(RuntimeFact fact) {
        this.main.resize();
        int hash = this.hash(fact);
        int addr = this.main.findBinIndex(this.reusableValueArr, hash, this.SHARED_ARRAY_EQ);
        ValueRowImpl found = (ValueRowImpl)this.main.get(addr);
        if (found == null && (found = (ValueRowImpl)this.delta.get(addr = this.delta.findBinIndex(this.reusableValueArr, hash, this.SHARED_ARRAY_EQ))) == null) {
            ValueRowImpl vr = new ValueRowImpl(Arrays.copyOf(this.reusableValueArr, this.reusableValueArr.length), hash, fact);
            this.delta.saveDirect(vr, addr);
            return true;
        }
        found.addFact(fact);
        return false;
    }

    @Override
    public void insertDirect(RuntimeFact fact) {
        this.main.resize();
        int hash = this.hash(fact);
        int addr = this.main.findBinIndex(this.reusableValueArr, hash, this.SHARED_ARRAY_EQ);
        ValueRowImpl found = (ValueRowImpl)this.main.get(addr);
        if (found == null) {
            found = new ValueRowImpl(Arrays.copyOf(this.reusableValueArr, this.reusableValueArr.length), hash);
            this.main.saveDirect(found, addr);
        }
        found.addFact(fact);
    }

    @Override
    public void mergeDelta() {
        this.main.addAll(this.delta);
        this.delta.clear();
    }
}

