/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.spi.minimal.JcCompiler;
import org.evrete.spi.minimal.TypeImpl;

class TypeResolverImpl
implements TypeResolver {
    private static final List<Class<?>> EMPTY_CLASS_LIST = new ArrayList();
    private final Map<String, TypeImpl> typeDeclarationMap = new HashMap<String, TypeImpl>();
    private final Map<String, TypeCacheEntry> typeInheritanceCache = new HashMap<String, TypeCacheEntry>();
    private final JcCompiler compiler;
    private int typeCounter = 0;
    private int fieldSetsCounter = 0;

    public TypeResolverImpl(JcCompiler compiler) {
        this.compiler = compiler;
    }

    private TypeResolverImpl(TypeResolverImpl other) {
        this.compiler = other.compiler;
        this.typeCounter = other.typeCounter;
        this.fieldSetsCounter = other.fieldSetsCounter;
        for (Map.Entry<String, TypeImpl> entry : other.typeDeclarationMap.entrySet()) {
            this.typeDeclarationMap.put(entry.getKey(), entry.getValue().copyOf());
        }
    }

    private static List<Class<?>> superClasses(Class<?> subject) {
        if (subject.isArray() || subject.isPrimitive() || subject.equals(Object.class)) {
            return EMPTY_CLASS_LIST;
        }
        ArrayList l = new ArrayList();
        Class<?> current = subject.getSuperclass();
        while (!current.equals(Object.class)) {
            l.add(current);
            current = current.getSuperclass();
        }
        return l;
    }

    @Override
    public Collection<Type> getKnownTypes() {
        return Collections.unmodifiableCollection(this.typeDeclarationMap.values());
    }

    @Override
    public TypeImpl getType(String name) {
        return this.typeDeclarationMap.get(name);
    }

    private TypeImpl findInSuperClasses(String name) {
        LinkedList<TypeImpl> matching = new LinkedList<TypeImpl>();
        for (TypeImpl existing : this.typeDeclarationMap.values()) {
            Class<?> clazz = existing.getClazz();
            if (clazz == null) continue;
            List<Class<?>> superClasses = TypeResolverImpl.superClasses(clazz);
            for (Class<?> sup : superClasses) {
                if (!sup.getName().equals(name)) continue;
                matching.add(existing);
            }
        }
        switch (matching.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (TypeImpl)matching.iterator().next();
            }
        }
        Logger.getAnonymousLogger().warning("Unable to resolve type '" + name + "' due to ambiguity.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeImpl resolve(Object o) {
        String name = o.getClass().getName();
        TypeImpl found = this.typeDeclarationMap.get(name);
        if (found == null) {
            TypeResolverImpl typeResolverImpl = this;
            synchronized (typeResolverImpl) {
                TypeCacheEntry cacheEntry = this.typeInheritanceCache.get(name);
                if (cacheEntry == null) {
                    cacheEntry = new TypeCacheEntry(this.findInSuperClasses(name));
                    this.typeInheritanceCache.put(name, cacheEntry);
                }
                found = cacheEntry.type;
            }
        }
        return found;
    }

    @Override
    public TypeResolverImpl copyOf() {
        return new TypeResolverImpl(this);
    }

    @Override
    public final synchronized TypeImpl declare(String typeName) {
        TypeImpl type = this.typeDeclarationMap.get(typeName);
        if (type == null) {
            type = TypeImpl.factory(this.compiler, typeName);
            this.typeDeclarationMap.put(typeName, type);
            if (type.getClazz() != null) {
                this.typeInheritanceCache.clear();
            }
            return type;
        }
        throw new IllegalArgumentException("Type named '" + typeName + "' has been already declared");
    }

    private static class TypeCacheEntry {
        private final TypeImpl type;

        TypeCacheEntry(TypeImpl resolved) {
            this.type = resolved;
        }
    }
}

