/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import org.evrete.api.ReIterator;
import org.evrete.api.RuntimeFact;
import org.evrete.api.ValueRow;
import org.evrete.collections.FastIdentityHashSet;
import org.evrete.spi.minimal.MiscUtils;

class ValueRowImpl
implements ValueRow {
    private final FastIdentityHashSet<RuntimeFact> facts = new FastIdentityHashSet();
    final Object[] data;
    private final int hash;
    private final ReIterator<RuntimeFact> delegate;

    ValueRowImpl(Object[] data, int hash, RuntimeFact fact) {
        this(data, hash);
        this.facts.add(fact);
    }

    ValueRowImpl(Object[] data, int hash) {
        this.data = data;
        this.hash = hash;
        this.delegate = this.facts.iterator();
    }

    void mergeDataFrom(ValueRowImpl other) {
        this.facts.bulkAdd(other.facts);
    }

    void addFact(RuntimeFact fact) {
        this.facts.add(fact);
    }

    long removeFact(RuntimeFact fact) {
        this.facts.remove(fact);
        return this.facts.size();
    }

    @Override
    public long reset() {
        return this.delegate.reset();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public RuntimeFact next() {
        return (RuntimeFact)this.delegate.next();
    }

    @Override
    public ReIterator<RuntimeFact> iterator() {
        return this.facts.iterator();
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    @Override
    public Object get(int i) {
        return this.data[i];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueRowImpl other = (ValueRowImpl)o;
        return MiscUtils.sameData(other.data, this.data);
    }

    public final int hashCode() {
        return this.hash;
    }
}

