/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public final class CollectionUtils {
    public static <T> T[] appendToArray(T[] old, T newValue) {
        T[] newArr = Arrays.copyOf(old, old.length + 1);
        newArr[newArr.length - 1] = newValue;
        return newArr;
    }

    public static <T> void fillIfNull(T[] arr, T newValue) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != null) continue;
            arr[i] = newValue;
        }
    }

    public static <S, T> int[] locate2(S subject, T[][] scope, BiPredicate<S, T> matchFunction) {
        for (int x = 0; x < scope.length; ++x) {
            T[] sub = scope[x];
            for (int y = 0; y < sub.length; ++y) {
                T o = sub[y];
                if (!matchFunction.test(subject, o)) continue;
                return new int[]{x, y};
            }
        }
        return null;
    }

    public static <T> boolean deleteFrom(Collection<T> collection, Predicate<T> predicate) {
        LinkedList<T> selected = new LinkedList<T>();
        for (T obj : collection) {
            if (!predicate.test(obj)) continue;
            selected.add(obj);
        }
        if (selected.isEmpty()) {
            return false;
        }
        for (Object o : selected) {
            collection.remove(o);
        }
        return true;
    }

    public static <T> T[] array(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static <E> List<List<E>> permutation(List<E> l) {
        ArrayList<E> original = new ArrayList<E>(l);
        if (original.size() == 0) {
            ArrayList result = new ArrayList();
            result.add(new ArrayList());
            return result;
        }
        E first = original.remove(0);
        ArrayList<List<ArrayList<E>>> result = new ArrayList<List<ArrayList<E>>>();
        List<List<E>> permutations = CollectionUtils.permutation(original);
        for (List<E> list : permutations) {
            for (int i = 0; i <= list.size(); ++i) {
                ArrayList<E> temp = new ArrayList<E>(list);
                temp.add(i, first);
                result.add(temp);
            }
        }
        return result;
    }

    public static <E, T extends Collection<E>> Collection<List<E>> combinations(Collection<T> sources) {
        LinkedHashMap<Integer, Collection> mapper = new LinkedHashMap<Integer, Collection>();
        int counter = 0;
        for (Collection collection : sources) {
            mapper.put(counter++, collection);
        }
        List combinations = CollectionUtils.combinations(mapper, LinkedHashMap::new);
        LinkedList result = new LinkedList();
        for (Map m : combinations) {
            LinkedList l = new LinkedList(m.values());
            result.add(l);
        }
        return result;
    }

    public static <K, V, C extends Collection<V>> List<Map<K, V>> combinations(Map<K, C> sources, Supplier<Map<K, V>> emptyMapSupplier) {
        Iterator<Map.Entry<K, C>> it = sources.entrySet().iterator();
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        Map.Entry<K, C> rootCollection = it.next();
        Collection c = (Collection)rootCollection.getValue();
        K k = rootCollection.getKey();
        ArrayList<Map<K, V>> response = new ArrayList<Map<K, V>>(c.size());
        for (Object o : c) {
            Map m = emptyMapSupplier.get();
            m.put(k, o);
            response.add(m);
        }
        while (it.hasNext()) {
            rootCollection = it.next();
            c = (Collection)rootCollection.getValue();
            k = rootCollection.getKey();
            if (c.isEmpty()) continue;
            ArrayList newResponse = new ArrayList(c.size() * response.size());
            for (Object e : c) {
                for (Map map : response) {
                    Map newResponseEntry = emptyMapSupplier.get();
                    newResponseEntry.putAll(map);
                    newResponseEntry.put(k, e);
                    newResponse.add(newResponseEntry);
                }
            }
            response = newResponse;
        }
        return response;
    }

    public static void systemFill(int[] array, int value) {
        CollectionUtils.systemFill(array, 0, array.length, value);
    }

    public static void systemFill(boolean[] array, boolean value) {
        CollectionUtils.systemFill(array, 0, array.length, value);
    }

    public static <T> void systemFill(T[] array, T value) {
        CollectionUtils.systemFill(array, 0, array.length, value);
    }

    private static <T> void systemFill(T[] array, int fromIndex, int toIndex, T value) {
        int len = toIndex - fromIndex;
        if (len < 64) {
            CollectionUtils.fillObjects(array, fromIndex, toIndex, value);
        } else {
            array[fromIndex] = value;
            for (int i = 1; i < len; i += i) {
                System.arraycopy(array, fromIndex, array, i + fromIndex, Math.min(len - i, i));
            }
        }
    }

    public static void systemFill(int[] array, int fromIndex, int toIndex, int value) {
        int len = toIndex - fromIndex;
        if (len < 64) {
            CollectionUtils.fillInts(array, fromIndex, toIndex, value);
        } else {
            array[fromIndex] = value;
            for (int i = 1; i < len; i += i) {
                System.arraycopy(array, fromIndex, array, i + fromIndex, Math.min(len - i, i));
            }
        }
    }

    private static void systemFill(boolean[] array, int fromIndex, int toIndex, boolean value) {
        int len = toIndex - fromIndex;
        if (len < 64) {
            CollectionUtils.fillBooleans(array, fromIndex, toIndex, value);
        } else {
            array[fromIndex] = value;
            for (int i = 1; i < len; i += i) {
                System.arraycopy(array, fromIndex, array, i + fromIndex, Math.min(len - i, i));
            }
        }
    }

    public static <Z> int[] toIntArray(Collection<Z> collection, ToIntFunction<Z> mapper) {
        int[] arr = new int[collection.size()];
        int i = 0;
        for (Z o : collection) {
            arr[i++] = mapper.applyAsInt(o);
        }
        return arr;
    }

    private static void fillBooleans(boolean[] a, int fromIndex, int toIndex, boolean val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    private static void fillInts(int[] a, int fromIndex, int toIndex, int val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    private static <T> void fillObjects(T[] a, int fromIndex, int toIndex, T val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }
}

