/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.function.IntPredicate;
import org.evrete.util.CollectionUtils;

class ArrayBulkCleanupData {
    private static final int NULL_VALUE = -1;
    private final int[] indices;
    private final int[] lengths;
    private int currentIndex;

    public ArrayBulkCleanupData(int size) {
        this.indices = new int[size];
        this.lengths = new int[size];
        CollectionUtils.systemFill(this.indices, -1);
        CollectionUtils.systemFill(this.lengths, -1);
        this.currentIndex = -1;
    }

    private void add(int i) {
        if (this.currentIndex == -1) {
            this.currentIndex = 0;
            this.indices[this.currentIndex] = i;
            this.lengths[this.currentIndex] = 1;
        } else if (this.indices[this.currentIndex] + this.lengths[this.currentIndex] == i) {
            int n = this.currentIndex;
            this.lengths[n] = this.lengths[n] + 1;
        } else {
            ++this.currentIndex;
            this.indices[this.currentIndex] = i;
            this.lengths[this.currentIndex] = 1;
        }
    }

    int clean(int[] data, IntPredicate predicate) {
        for (int i = 0; i < this.indices.length; ++i) {
            if (!predicate.test(data[i])) continue;
            this.add(i);
        }
        return this.applyTo(data, this.indices.length);
    }

    private int applyTo(Object array, int initialSize) {
        int idx;
        int totalDeleted = 0;
        for (int i = 0; i < this.indices.length && (idx = this.indices[i]) != -1; ++i) {
            int adjustedIdx = idx - totalDeleted;
            int len = this.lengths[i];
            int srcPos = idx + len - totalDeleted;
            int copyLength = initialSize - idx - len;
            System.arraycopy(array, srcPos, array, adjustedIdx, copyLength);
            totalDeleted += len;
        }
        return totalDeleted;
    }
}

