/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.evrete.api.Evaluator;
import org.evrete.api.NamedType;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ConditionNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.NodeDescriptor;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.builder.AbstractLhsBuilder;
import org.evrete.runtime.builder.FactTypeBuilder;
import org.evrete.runtime.evaluation.EvaluatorFactory;
import org.evrete.runtime.evaluation.EvaluatorGroup;
import org.evrete.util.CollectionUtils;
import org.evrete.util.MapFunction;
import org.evrete.util.NextIntSupplier;

public abstract class AbstractLhsDescriptor {
    private final MapFunction<String, int[]> nameIndices = new MapFunction();
    private final int level;
    private final Set<FactType> groupFactTypes = new HashSet<FactType>();
    private final RhsFactGroupDescriptor[] allFactGroups;

    AbstractLhsDescriptor(AbstractRuntime<?> runtime, AbstractLhsDescriptor parent, AbstractLhsBuilder<?, ?> group, NextIntSupplier factIdGenerator, MapFunction<NamedType, FactType> typeMapping) {
        this.level = parent == null ? 0 : parent.level + 1;
        Set<FactTypeBuilder> declaredTypes = group.getDeclaredFactTypes();
        AbstractLhsBuilder.Compiled compiledConditions = group.getCompiledData();
        HashSet<FactType> keyedFactTypes = new HashSet<FactType>();
        ArrayList<FactType> alphaFactTypes = new ArrayList<FactType>();
        for (FactTypeBuilder builder : declaredTypes) {
            Set<Evaluator> alphaConditions;
            FactType factType = FactType.factory(runtime, builder, alphaConditions = compiledConditions.getAlphaConditions(builder), factIdGenerator);
            if (factType.getFields().size() == 0) {
                alphaFactTypes.add(factType);
            } else {
                keyedFactTypes.add(factType);
            }
            typeMapping.putNew(builder, factType);
            for (FactType existing : this.groupFactTypes) {
                boolean sameAlpha;
                int sameKeys = existing.getFields().equals(factType.getFields()) ? 1 : 0;
                boolean bl = sameAlpha = existing.getBucketIndex() == factType.getBucketIndex();
                if (sameKeys == 0 || !sameAlpha) continue;
                existing.markNonUniqueKeyAndAlpha();
                factType.markNonUniqueKeyAndAlpha();
            }
            this.groupFactTypes.add(factType);
        }
        ConditionNodeDescriptor[] finalNodes = AbstractLhsDescriptor.findBestAllocation(compiledConditions, typeMapping);
        ArrayList<RhsFactGroupDescriptor> allFactGroups = new ArrayList<RhsFactGroupDescriptor>();
        int factGroupCounter = 0;
        int keyGroupIndex = 0;
        for (ConditionNodeDescriptor finalNode : finalNodes) {
            RhsFactGroupDescriptor descriptor = new RhsFactGroupDescriptor(this, factGroupCounter, keyGroupIndex, finalNode);
            allFactGroups.add(descriptor);
            ++factGroupCounter;
            ++keyGroupIndex;
            keyedFactTypes.removeAll(Arrays.asList(descriptor.getTypes()));
        }
        for (FactType keyedType : keyedFactTypes) {
            RhsFactGroupDescriptor descriptor = new RhsFactGroupDescriptor(this, factGroupCounter, keyGroupIndex, keyedType);
            allFactGroups.add(descriptor);
            ++factGroupCounter;
            ++keyGroupIndex;
        }
        if (!alphaFactTypes.isEmpty()) {
            allFactGroups.add(new RhsFactGroupDescriptor(this, factGroupCounter, alphaFactTypes));
        }
        for (RhsFactGroupDescriptor descriptor : allFactGroups) {
            FactType[] types = descriptor.getTypes();
            int factGroupIndex = descriptor.getFactGroupIndex();
            for (int i = 0; i < types.length; ++i) {
                this.nameIndices.putNew(types[i].getVar(), new int[]{factGroupIndex, i});
            }
        }
        this.allFactGroups = allFactGroups.toArray(RhsFactGroupDescriptor.ZERO_ARRAY);
    }

    MapFunction<String, int[]> getNameIndices() {
        return this.nameIndices;
    }

    RhsFactGroupDescriptor[] getAllFactGroups() {
        return this.allFactGroups;
    }

    private static ConditionNodeDescriptor[] findBestAllocation(AbstractLhsBuilder.Compiled lhsBuilder, MapFunction<NamedType, FactType> mapping) {
        HashSet<Evaluator> betaConditions = new HashSet<Evaluator>(lhsBuilder.getBetaConditions());
        if (betaConditions.isEmpty()) {
            return ConditionNodeDescriptor.ZERO_ARRAY;
        }
        List<EvaluatorGroup> evaluators = EvaluatorFactory.flattenEvaluators(betaConditions, mapping);
        HashSet<FactType> betaTypes = new HashSet<FactType>();
        TreeMap<Integer, List> grouped = new TreeMap<Integer, List>();
        for (EvaluatorGroup evaluatorGroup : evaluators) {
            int n = evaluatorGroup.descriptor().size();
            grouped.computeIfAbsent(n, k -> new ArrayList()).add(evaluatorGroup);
            betaTypes.addAll(evaluatorGroup.descriptor());
        }
        TreeMap groupedPermutations = new TreeMap();
        for (Map.Entry entry : grouped.entrySet()) {
            groupedPermutations.put((Integer)entry.getKey(), CollectionUtils.permutation((List)entry.getValue()));
        }
        List list = CollectionUtils.combinations(groupedPermutations, TreeMap::new);
        LinkedList linkedList = new LinkedList();
        for (Map map : list) {
            LinkedList l = new LinkedList();
            for (Integer n : map.keySet()) {
                l.addAll((Collection)map.get(n));
            }
            linkedList.add(l);
        }
        Collection<ConditionNodeDescriptor> best = null;
        double min = Double.MAX_VALUE;
        for (List list2 : linkedList) {
            Collection<ConditionNodeDescriptor> finalNodes = ConditionNodeDescriptor.allocateConditions(betaTypes, list2);
            double complexity = 0.0;
            for (ConditionNodeDescriptor cnd : finalNodes) {
                complexity += AbstractLhsDescriptor.complexity(cnd);
            }
            if (!(complexity < min)) continue;
            min = complexity;
            best = finalNodes;
        }
        assert (best != null);
        return best.toArray(ConditionNodeDescriptor.ZERO_ARRAY);
    }

    private static double complexity(ConditionNodeDescriptor node) {
        NodeDescriptor[] sources = node.getSources();
        double[] distances = new double[sources.length];
        double sum = 0.0;
        for (int i = 0; i < sources.length; ++i) {
            double d;
            distances[i] = d = AbstractLhsDescriptor.distanceToEntryNode(sources[i]);
            sum += d;
        }
        double avg = sum / (double)sources.length;
        double deviation = 0.0;
        for (double distance : distances) {
            deviation += Math.pow(distance - avg, 2.0);
        }
        return avg * (1.0 + deviation);
    }

    private static double distanceToEntryNode(NodeDescriptor node) {
        double distance = 0.0;
        if (node.isConditionNode()) {
            for (NodeDescriptor source : node.getSources()) {
                if (source.isConditionNode()) {
                    distance += 1.0 + AbstractLhsDescriptor.distanceToEntryNode(source);
                    continue;
                }
                distance += 1.0;
            }
            distance /= (double)node.getSources().length;
        }
        return distance;
    }

    public int getLevel() {
        return this.level;
    }

    public Set<FactType> getGroupFactTypes() {
        return this.groupFactTypes;
    }

    public String toString() {
        return "{factGroups=" + Arrays.toString(this.allFactGroups) + '}';
    }
}

