/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.evrete.Configuration;
import org.evrete.api.ActiveField;
import org.evrete.api.EvaluationListener;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldsKey;
import org.evrete.api.KeysStore;
import org.evrete.api.Named;
import org.evrete.api.NamedType;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.api.TypeResolverWrapper;
import org.evrete.runtime.ActiveFields;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeListeners;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.builder.RuleBuilderImpl;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.evaluation.AlphaConditions;
import org.evrete.runtime.evaluation.AlphaDelta;

public abstract class AbstractRuntime<C extends RuntimeContext<C>>
implements RuntimeContext<C> {
    private final List<RuleBuilder<C>> ruleBuilders = new ArrayList<RuleBuilder<C>>();
    private final List<RuleDescriptor> ruleDescriptors;
    private final AtomicInteger ruleCounter;
    private final RuntimeListeners listeners;
    private final Configuration configuration;
    private TypeResolver typeResolver;
    private final AlphaConditions alphaConditions;
    private final ForkJoinExecutor executor;
    private final ActiveFields activeFields;
    private Comparator<Rule> ruleComparator = SALIENCE_COMPARATOR;

    protected abstract void onNewActiveField(ActiveField var1);

    protected abstract void onNewAlphaBucket(AlphaDelta var1);

    AbstractRuntime(Configuration configuration, ForkJoinExecutor executor) {
        this.configuration = configuration;
        this.typeResolver = configuration.getResolverService().newInstance();
        this.ruleCounter = new AtomicInteger();
        this.alphaConditions = new AlphaConditions();
        this.ruleDescriptors = new ArrayList<RuleDescriptor>();
        this.listeners = new RuntimeListeners();
        this.executor = executor;
        this.activeFields = new ActiveFields();
    }

    protected AbstractRuntime(AbstractRuntime<?> parent) {
        this.configuration = parent.configuration;
        this.typeResolver = (TypeResolver)parent.typeResolver.copyOf();
        this.ruleCounter = new AtomicInteger(parent.ruleCounter.intValue());
        this.alphaConditions = parent.alphaConditions.copyOf();
        this.ruleDescriptors = new ArrayList<RuleDescriptor>(parent.ruleDescriptors);
        this.executor = parent.executor;
        this.listeners = parent.listeners.copyOf();
        this.activeFields = parent.activeFields.copyOf();
        this.ruleComparator = parent.ruleComparator;
    }

    @Override
    public Comparator<Rule> getRuleComparator() {
        return this.ruleComparator;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        this.ruleComparator = ruleComparator;
    }

    protected ForkJoinExecutor getExecutor() {
        return this.executor;
    }

    public Evaluator compile(String expression, Function<String, NamedType> resolver) {
        return this.configuration.getExpressionsService().buildExpression(expression, resolver);
    }

    @Override
    public void wrapTypeResolver(TypeResolverWrapper wrapper) {
        this.typeResolver = wrapper;
    }

    public ActiveField getCreateActiveField(TypeField field) {
        return this.activeFields.getCreate(field, this::onNewActiveField);
    }

    public ActiveField[] getActiveFields(Type type) {
        return this.activeFields.getActiveFields(type);
    }

    AlphaBucketMeta getCreateAlphaMask(FieldsKey fields, boolean beta, Set<Evaluator> typePredicates) {
        return this.alphaConditions.register(this, fields, beta, typePredicates, this::onNewAlphaBucket);
    }

    @Override
    public RuntimeListeners getListeners() {
        return this.listeners;
    }

    public List<RuleDescriptor> getRuleDescriptors() {
        return this.ruleDescriptors;
    }

    public AlphaConditions getAlphaConditions() {
        return this.alphaConditions;
    }

    @Override
    public RuleBuilder<C> newRule() {
        return this.newRule(RuleBuilderImpl.class.getName() + "#" + this.ruleCounter.get());
    }

    @Override
    public RuleBuilderImpl<C> newRule(String name) {
        RuleBuilderImpl rb = new RuleBuilderImpl(this, name, -1 * this.ruleCounter.getAndIncrement());
        this.ruleBuilders.add(rb);
        return rb;
    }

    @Override
    public boolean ruleExists(String name) {
        Objects.requireNonNull(name);
        return Named.find(this.ruleDescriptors, name) != null;
    }

    @Override
    public RuleDescriptor getRuleDescriptor(String name) {
        return Named.find(this.ruleDescriptors, name);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <Z> KeysStore newKeysStore(Z[][] grouping) {
        return this.configuration.getCollectionsService().newKeyStore(grouping);
    }

    public KeysStore newKeysStore(int[] factTypeCounts) {
        return this.configuration.getCollectionsService().newKeyStore(factTypeCounts);
    }

    @Override
    public final synchronized RuleDescriptor compileRule(RuleBuilder<?> ruleBuilder) {
        if (!this.ruleBuilders.remove(ruleBuilder)) {
            throw new IllegalArgumentException("No such rule builder");
        }
        if (this.ruleExists(ruleBuilder.getName())) {
            throw new IllegalArgumentException("Rule '" + ruleBuilder.getName() + "' already exists");
        }
        RuleBuilderImpl rb = (RuleBuilderImpl)ruleBuilder;
        RuleDescriptor rd = new RuleDescriptor(this, rb);
        this.ruleDescriptors.add(rd);
        return rd;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public void addConditionTestListener(EvaluationListener listener) {
        this.listeners.addConditionTestListener(listener);
    }
}

