/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evrete.runtime.EntryNodeDescriptor;
import org.evrete.runtime.FactType;
import org.evrete.runtime.NodeDescriptor;
import org.evrete.runtime.evaluation.EvaluatorGroup;
import org.evrete.util.Bits;
import org.evrete.util.CollectionUtils;
import org.evrete.util.NextIntSupplier;

public class ConditionNodeDescriptor
extends NodeDescriptor {
    public static final ConditionNodeDescriptor[] ZERO_ARRAY = new ConditionNodeDescriptor[0];
    private final EvaluatorGroup expression;
    private final int[] nonPlainSourceIndices;
    private final Map<Integer, TypeLocator> typeLocators = new HashMap<Integer, TypeLocator>();

    private ConditionNodeDescriptor(NextIntSupplier idSupplier, EvaluatorGroup expression, Set<NodeDescriptor> sourceNodes) {
        super(idSupplier, (Set<? extends NodeDescriptor>)sourceNodes);
        this.expression = expression;
        ArrayList<Integer> nonPlainSourceIndicesList = new ArrayList<Integer>();
        for (NodeDescriptor src : sourceNodes) {
            FactType[][] conditionGrouping;
            HashSet<FactType> allSourceTypes = new HashSet<FactType>(Arrays.asList(src.getTypes()));
            HashSet<FactType> conditionTypes = new HashSet<FactType>();
            Set<FactType> descriptor = expression.descriptor();
            for (FactType refType : descriptor) {
                if (!allSourceTypes.contains(refType)) continue;
                allSourceTypes.remove(refType);
                conditionTypes.add(refType);
            }
            FactType[] primary = FactType.toArray(conditionTypes);
            if (allSourceTypes.isEmpty()) {
                conditionGrouping = new FactType[][]{primary};
            } else {
                FactType[] secondary = FactType.toArray(allSourceTypes);
                conditionGrouping = new FactType[][]{primary, secondary};
                nonPlainSourceIndicesList.add(src.getSourceIndex());
            }
            src.setEvalGrouping(conditionGrouping);
        }
        this.nonPlainSourceIndices = CollectionUtils.toIntArray(nonPlainSourceIndicesList, i -> i);
        for (FactType type : this.getTypes()) {
            TypeLocator locator = null;
            for (NodeDescriptor source : this.getSources()) {
                TypeLocator tl = TypeLocator.find(type, source);
                if (tl == null) continue;
                if (locator == null) {
                    locator = tl;
                    continue;
                }
                throw new IllegalStateException("Integrity violation");
            }
            if (locator == null) {
                throw new IllegalStateException("Integrity violation: " + type + " at " + this);
            }
            this.typeLocators.put(type.getInRuleIndex(), locator);
        }
    }

    static Collection<ConditionNodeDescriptor> allocateConditions(Collection<FactType> betaTypes, List<EvaluatorGroup> list) {
        EvaluatorGroup[] evaluatorSequence;
        HashSet<NodeDescriptor> unallocatedNodes = new HashSet<NodeDescriptor>();
        NextIntSupplier idSupplier = new NextIntSupplier();
        for (FactType factType : betaTypes) {
            EntryNodeDescriptor e = new EntryNodeDescriptor(idSupplier, factType);
            unallocatedNodes.add(e);
        }
        for (EvaluatorGroup evaluator : evaluatorSequence = list.toArray(EvaluatorGroup.ZERO_ARRAY)) {
            Set<NodeDescriptor> matching = Bits.matchesOR(evaluator.getTypeMask(), unallocatedNodes, NodeDescriptor::getMask);
            assert (!matching.isEmpty());
            unallocatedNodes.removeAll(matching);
            unallocatedNodes.add(new ConditionNodeDescriptor(idSupplier, evaluator, matching));
        }
        ArrayList<ConditionNodeDescriptor> arrayList = new ArrayList<ConditionNodeDescriptor>(unallocatedNodes.size());
        for (NodeDescriptor nd : unallocatedNodes) {
            if (!nd.isConditionNode()) continue;
            ConditionNodeDescriptor cnd = (ConditionNodeDescriptor)nd;
            cnd.setEvalGrouping(new FactType[][]{cnd.getTypes()});
            arrayList.add(cnd);
        }
        return arrayList;
    }

    @Override
    public boolean isConditionNode() {
        return true;
    }

    public TypeLocator locate(FactType type) {
        TypeLocator locator = this.typeLocators.get(type.getInRuleIndex());
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        return locator;
    }

    public int[] getNonPlainSourceIndices() {
        return this.nonPlainSourceIndices;
    }

    public EvaluatorGroup getExpression() {
        return this.expression;
    }

    public String toString() {
        return "{id=" + this.getIndex() + ", expression=" + this.expression + ", mask=" + this.getMask() + '}';
    }

    public static class TypeLocator {
        public final int source;
        public final int level;
        public final int position;

        private TypeLocator(int source, int level, int position) {
            this.source = source;
            this.level = level;
            this.position = position;
        }

        static TypeLocator find(FactType subject, NodeDescriptor source) {
            FactType[][] grouping = source.getEvalGrouping();
            for (int level = 0; level < grouping.length; ++level) {
                FactType[] levelTypes = grouping[level];
                for (int position = 0; position < levelTypes.length; ++position) {
                    FactType type = levelTypes[position];
                    if (type.getInRuleIndex() != subject.getInRuleIndex()) continue;
                    return new TypeLocator(source.getSourceIndex(), level, position);
                }
            }
            return null;
        }
    }
}

