/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import org.evrete.api.ActiveField;
import org.evrete.api.Evaluator;
import org.evrete.api.FieldsKey;
import org.evrete.api.Masked;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.builder.FactTypeBuilder;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.util.Bits;
import org.evrete.util.NextIntSupplier;

public class FactType
implements Masked {
    public static final FactType[] ZERO_ARRAY = new FactType[0];
    private static final Comparator<FactType> COMPARATOR = Comparator.comparingInt(FactType::getInRuleIndex);
    public static final BiPredicate<FactType, FactType> EQUALITY_BY_INDEX = (t1, t2) -> t1.getInRuleIndex() == t2.getInRuleIndex();
    private final String var;
    private final Type type;
    private final AlphaBucketMeta alphaMask;
    private final FieldsKey fields;
    private final int inRuleIndex;
    private final Bits mask;
    private boolean uniqueKeyAndAlpha = true;
    private RhsFactGroupDescriptor factGroup;
    private int inGroupIndex = -1;

    private FactType(AbstractRuntime<?> runtime, FactTypeBuilder builder, Set<Evaluator> alphaConditions, NextIntSupplier factIdGenerator) {
        this.type = builder.getType();
        this.var = builder.getVar();
        this.inRuleIndex = factIdGenerator.next();
        HashSet<ActiveField> activeFields = new HashSet<ActiveField>();
        for (TypeField f : builder.getBetaTypeFields()) {
            activeFields.add(runtime.getCreateActiveField(f));
        }
        this.fields = new FieldsKey(this.type, activeFields);
        this.mask = new Bits();
        this.mask.set(this.inRuleIndex);
        this.alphaMask = runtime.getCreateAlphaMask(this.fields, builder.isBetaTypeBuilder(), alphaConditions);
    }

    FactType(FactType other) {
        assert (other.factGroup != null);
        assert (other.inGroupIndex >= 0);
        this.inGroupIndex = other.inGroupIndex;
        this.factGroup = other.factGroup;
        this.mask = other.mask;
        this.var = other.var;
        this.alphaMask = other.alphaMask;
        this.fields = other.fields;
        this.inRuleIndex = other.inRuleIndex;
        this.type = other.type;
        this.uniqueKeyAndAlpha = other.uniqueKeyAndAlpha;
    }

    public static FactType[] toArray(Collection<FactType> set) {
        FactType[] arr = set.toArray(ZERO_ARRAY);
        Arrays.sort(arr, COMPARATOR);
        return arr;
    }

    static FactType factory(AbstractRuntime<?> runtime, FactTypeBuilder builder, Set<Evaluator> alphaConditions, NextIntSupplier factIdGenerator) {
        return new FactType(runtime, builder, alphaConditions, factIdGenerator);
    }

    public RhsFactGroupDescriptor getFactGroup() {
        Objects.requireNonNull(this.factGroup);
        return this.factGroup;
    }

    public int getBucketIndex() {
        return this.alphaMask.getBucketIndex();
    }

    public void markNonUniqueKeyAndAlpha() {
        this.uniqueKeyAndAlpha = false;
    }

    public boolean isUniqueKeyAndAlpha() {
        return this.uniqueKeyAndAlpha;
    }

    void setFactGroup(RhsFactGroupDescriptor factGroup) {
        if (this.factGroup != null) {
            throw new IllegalStateException();
        }
        this.factGroup = factGroup;
        this.inGroupIndex = factGroup.positionOf(this);
    }

    public int findFieldPosition(TypeField field) {
        ActiveField[] arr = this.fields.getFields();
        for (int i = 0; i < arr.length; ++i) {
            ActiveField f = arr[i];
            if (f.getDelegate() != field) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    public FieldsKey getFields() {
        return this.fields;
    }

    public AlphaBucketMeta getAlphaMask() {
        return this.alphaMask;
    }

    public String getVar() {
        return this.var;
    }

    public Type getType() {
        return this.fields.getType();
    }

    public int getInRuleIndex() {
        return this.inRuleIndex;
    }

    public int getInGroupIndex() {
        return this.inGroupIndex;
    }

    @Override
    public Bits getMask() {
        return this.mask;
    }

    public String toString() {
        return "FactType{var='" + this.var + '\'' + ", type=" + this.type + '}';
    }
}

