/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.EnumMap;
import java.util.function.BooleanSupplier;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyReIterators;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueRow;
import org.evrete.runtime.RhsFactGroupIterator;

public class RhsKeysGroupIterator
implements KeyReIterators<ValueRow[]> {
    private static final BooleanSupplier TRUE_PREDICATE = () -> true;
    private final RhsFactGroupIterator groupIterator;
    private final ValueRow[][] state;
    private final int keyGroupId;
    private BooleanSupplier statePredicate = TRUE_PREDICATE;
    private final KeyReIterators<ValueRow[]> iterators;

    public RhsKeysGroupIterator(int keyGroupId, KeyReIterators<ValueRow[]> endNode, RhsFactGroupIterator groupIterator, ValueRow[][] state) {
        this.groupIterator = groupIterator;
        this.keyGroupId = keyGroupId;
        this.state = state;
        this.iterators = endNode;
    }

    @Override
    public EnumMap<KeyMode, ReIterator<ValueRow[]>> keyIterators() {
        return this.iterators.keyIterators();
    }

    boolean setSate(ValueRow[] key) {
        this.state[this.keyGroupId] = key;
        boolean b = this.statePredicate.getAsBoolean();
        if (b) {
            this.groupIterator.setIterables(key);
        }
        return b;
    }

    public void addStateKeyPredicate(BooleanSupplier predicate) {
        if (this.statePredicate == TRUE_PREDICATE) {
            this.statePredicate = predicate;
        } else {
            BooleanSupplier old = this.statePredicate;
            this.statePredicate = () -> old.getAsBoolean() && predicate.getAsBoolean();
        }
    }
}

