/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.RhsContext;
import org.evrete.runtime.LhsDescriptor;
import org.evrete.runtime.MemoryChangeListener;
import org.evrete.runtime.RhsFactGroupAlpha;
import org.evrete.runtime.RhsFactGroupBeta;
import org.evrete.runtime.RuntimeAggregateLhsJoined;
import org.evrete.runtime.RuntimeLhs;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.runtime.ScanMode;
import org.evrete.runtime.memory.Buffer;

public class RuntimeLhsDefault
extends RuntimeLhs
implements RhsContext,
MemoryChangeListener {
    private static final Collection<RuntimeAggregateLhsJoined> EMPTY_AGGREGATES = Collections.unmodifiableCollection(Collections.emptyList());

    RuntimeLhsDefault(RuntimeRuleImpl rule, LhsDescriptor descriptor, Buffer buffer) {
        super(rule, descriptor, buffer);
    }

    @Override
    public Collection<RuntimeAggregateLhsJoined> getAggregateConditionedGroups() {
        return EMPTY_AGGREGATES;
    }

    @Override
    public void forEach(Consumer<RhsContext> rhs) {
        this.forEach(() -> rhs.accept(this));
    }

    private void forEach(Runnable eachFactRunnable) {
        RhsFactGroupAlpha alphaGroup = this.getAlphaFactGroup();
        RhsFactGroupBeta[] betaGroups = this.getBetaFactGroups();
        if (alphaGroup != null) {
            boolean hasAlphaDelta = alphaGroup.hasDelta();
            if (betaGroups.length > 0) {
                if (hasAlphaDelta) {
                    RhsFactGroupBeta.runKeys(ScanMode.KNOWN, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.DELTA, eachFactRunnable)));
                    RhsFactGroupBeta.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.KNOWN, eachFactRunnable)));
                    RhsFactGroupBeta.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.DELTA, eachFactRunnable)));
                } else {
                    RhsFactGroupBeta.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, () -> alphaGroup.run(ScanMode.FULL, eachFactRunnable)));
                }
            } else {
                alphaGroup.run(ScanMode.DELTA, eachFactRunnable);
            }
        } else if (betaGroups.length > 0) {
            RhsFactGroupBeta.runKeys(ScanMode.DELTA, betaGroups, () -> RhsFactGroupBeta.runCurrentFacts(betaGroups, eachFactRunnable));
        } else {
            Logger.getAnonymousLogger().warning("No output groups");
        }
    }
}

