/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.function.Consumer;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeRule;
import org.evrete.runtime.AbstractRuntimeRule;
import org.evrete.runtime.ActivationSubject;
import org.evrete.runtime.MemoryChangeListener;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeLhs;
import org.evrete.runtime.memory.BetaEndNode;
import org.evrete.runtime.memory.Buffer;
import org.evrete.runtime.memory.SessionMemory;

public class RuntimeRuleImpl
extends AbstractRuntimeRule
implements MemoryChangeListener,
RuntimeRule,
ActivationSubject {
    private final RuntimeLhs lhs;
    private final Buffer ruleBuffer = new Buffer();
    private final Buffer memoryBuffer;

    public RuntimeRuleImpl(RuleDescriptor rd, SessionMemory memory) {
        super(rd, memory);
        this.memoryBuffer = memory.getBuffer();
        this.lhs = RuntimeLhs.factory(this, rd.getLhs(), this.ruleBuffer);
    }

    public final void executeRhs() {
        assert (this.isInActiveState());
        this.lhs.forEach(this.rhs);
        this.memoryBuffer.takeAllFrom(this.ruleBuffer);
        this.resetState();
    }

    @Override
    public final RuntimeRuleImpl setRhs(Consumer<RhsContext> consumer) {
        super.setRhs(consumer);
        return this;
    }

    @Override
    public final RuntimeRuleImpl chainRhs(Consumer<RhsContext> consumer) {
        super.chainRhs(consumer);
        return this;
    }

    @Override
    public void onAfterChange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInActiveState() {
        return this.lhs.isInActiveState();
    }

    @Override
    public void resetState() {
        this.lhs.resetState();
        for (BetaEndNode endNode : this.lhs.getAllBetaEndNodes()) {
            endNode.mergeDelta();
        }
    }

    @Override
    public RuntimeLhs getLhs() {
        return this.lhs;
    }
}

