/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.runtime.memory.Action;
import org.evrete.runtime.memory.Buffer;

public class BufferSafe
extends Buffer {
    private final Lock writeLock;

    public BufferSafe() {
        ReentrantReadWriteLock l = new ReentrantReadWriteLock();
        this.writeLock = l.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TypeResolver resolver, Action action, Collection<?> objects) {
        try {
            this.writeLock.lock();
            super.add(resolver, action, objects);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    void takeAll(Action action, BiConsumer<Type, Iterator<Object>> consumer) {
        try {
            this.writeLock.lock();
            super.takeAll(action, consumer);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    void clear() {
        try {
            this.writeLock.lock();
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

