/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.memory;

import java.util.Collection;
import org.evrete.api.FieldsKey;
import org.evrete.api.Memory;
import org.evrete.api.RuntimeFact;
import org.evrete.api.spi.CollectionsService;
import org.evrete.api.spi.SharedBetaFactStorage;
import org.evrete.runtime.RuntimeObject;
import org.evrete.runtime.evaluation.AlphaBucketMeta;
import org.evrete.runtime.memory.SessionMemory;

class FieldsMemoryBucket
implements Memory {
    private final SharedBetaFactStorage fieldData;
    private final AlphaBucketMeta alphaMask;

    FieldsMemoryBucket(SessionMemory runtime, FieldsKey typeFields, AlphaBucketMeta alphaMask) {
        CollectionsService collectionsService = runtime.getConfiguration().getCollectionsService();
        this.alphaMask = alphaMask;
        this.fieldData = collectionsService.newBetaStorage(typeFields);
    }

    public void clear() {
        this.fieldData.clear();
    }

    SharedBetaFactStorage getFieldData() {
        return this.fieldData;
    }

    @Override
    public void commitChanges() {
        this.fieldData.commitChanges();
    }

    void insert(Collection<RuntimeObject> facts) {
        this.fieldData.insert(facts, this.alphaMask);
    }

    void retract(Collection<RuntimeFact> facts) {
        for (RuntimeFact fact : facts) {
            if (this.alphaMask.test(fact) && !this.fieldData.delete(fact)) continue;
        }
    }
}

